package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDistributionProducts invokes the market.DescribeDistributionProducts API synchronously
func (client *Client) DescribeDistributionProducts(request *DescribeDistributionProductsRequest) (response *DescribeDistributionProductsResponse, err error) {
	response = CreateDescribeDistributionProductsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDistributionProductsWithChan invokes the market.DescribeDistributionProducts API asynchronously
func (client *Client) DescribeDistributionProductsWithChan(request *DescribeDistributionProductsRequest) (<-chan *DescribeDistributionProductsResponse, <-chan error) {
	responseChan := make(chan *DescribeDistributionProductsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDistributionProducts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDistributionProductsWithCallback invokes the market.DescribeDistributionProducts API asynchronously
func (client *Client) DescribeDistributionProductsWithCallback(request *DescribeDistributionProductsRequest, callback func(response *DescribeDistributionProductsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDistributionProductsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDistributionProducts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDistributionProductsRequest is the request struct for api DescribeDistributionProducts
type DescribeDistributionProductsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer                      `position:"Query" name:"PageNumber"`
	Filter     *[]DescribeDistributionProductsFilter `position:"Query" name:"Filter"  type:"Repeated"`
	PageSize   requests.Integer                      `position:"Query" name:"PageSize"`
}

// DescribeDistributionProductsFilter is a repeated param struct in DescribeDistributionProductsRequest
type DescribeDistributionProductsFilter struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDistributionProductsResponse is the response struct for api DescribeDistributionProducts
type DescribeDistributionProductsResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	Results    []Result `json:"Results" xml:"Results"`
}

// CreateDescribeDistributionProductsRequest creates a request to invoke DescribeDistributionProducts API
func CreateDescribeDistributionProductsRequest() (request *DescribeDistributionProductsRequest) {
	request = &DescribeDistributionProductsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "DescribeDistributionProducts", "yunmarket", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDistributionProductsResponse creates a response to parse from DescribeDistributionProducts response
func CreateDescribeDistributionProductsResponse() (response *DescribeDistributionProductsResponse) {
	response = &DescribeDistributionProductsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
