package mns_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateQueue invokes the mns_open.CreateQueue API synchronously
func (client *Client) CreateQueue(request *CreateQueueRequest) (response *CreateQueueResponse, err error) {
	response = CreateCreateQueueResponse()
	err = client.DoAction(request, response)
	return
}

// CreateQueueWithChan invokes the mns_open.CreateQueue API asynchronously
func (client *Client) CreateQueueWithChan(request *CreateQueueRequest) (<-chan *CreateQueueResponse, <-chan error) {
	responseChan := make(chan *CreateQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateQueueWithCallback invokes the mns_open.CreateQueue API asynchronously
func (client *Client) CreateQueueWithCallback(request *CreateQueueRequest, callback func(response *CreateQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateQueueResponse
		var err error
		defer close(result)
		response, err = client.CreateQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateQueueRequest is the request struct for api CreateQueue
type CreateQueueRequest struct {
	*requests.RpcRequest
	QueueName              string           `position:"Query" name:"QueueName"`
	MessageRetentionPeriod requests.Integer `position:"Query" name:"MessageRetentionPeriod"`
	EnableLogging          requests.Boolean `position:"Query" name:"EnableLogging"`
	VisibilityTimeout      requests.Integer `position:"Query" name:"VisibilityTimeout"`
	MaximumMessageSize     requests.Integer `position:"Query" name:"MaximumMessageSize"`
	DelaySeconds           requests.Integer `position:"Query" name:"DelaySeconds"`
	PollingWaitSeconds     requests.Integer `position:"Query" name:"PollingWaitSeconds"`
}

// CreateQueueResponse is the response struct for api CreateQueue
type CreateQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int64  `json:"Code" xml:"Code"`
	Status    string `json:"Status" xml:"Status"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateQueueRequest creates a request to invoke CreateQueue API
func CreateCreateQueueRequest() (request *CreateQueueRequest) {
	request = &CreateQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mns-open", "2022-01-19", "CreateQueue", "mns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateQueueResponse creates a response to parse from CreateQueue response
func CreateCreateQueueResponse() (response *CreateQueueResponse) {
	response = &CreateQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
