package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserAppDonwloadUrlInMsa invokes the mpaas.GetUserAppDonwloadUrlInMsa API synchronously
func (client *Client) GetUserAppDonwloadUrlInMsa(request *GetUserAppDonwloadUrlInMsaRequest) (response *GetUserAppDonwloadUrlInMsaResponse, err error) {
	response = CreateGetUserAppDonwloadUrlInMsaResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserAppDonwloadUrlInMsaWithChan invokes the mpaas.GetUserAppDonwloadUrlInMsa API asynchronously
func (client *Client) GetUserAppDonwloadUrlInMsaWithChan(request *GetUserAppDonwloadUrlInMsaRequest) (<-chan *GetUserAppDonwloadUrlInMsaResponse, <-chan error) {
	responseChan := make(chan *GetUserAppDonwloadUrlInMsaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserAppDonwloadUrlInMsa(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserAppDonwloadUrlInMsaWithCallback invokes the mpaas.GetUserAppDonwloadUrlInMsa API asynchronously
func (client *Client) GetUserAppDonwloadUrlInMsaWithCallback(request *GetUserAppDonwloadUrlInMsaRequest, callback func(response *GetUserAppDonwloadUrlInMsaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserAppDonwloadUrlInMsaResponse
		var err error
		defer close(result)
		response, err = client.GetUserAppDonwloadUrlInMsa(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserAppDonwloadUrlInMsaRequest is the request struct for api GetUserAppDonwloadUrlInMsa
type GetUserAppDonwloadUrlInMsaRequest struct {
	*requests.RpcRequest
	TenantId    string           `position:"Body" name:"TenantId"`
	Id          requests.Integer `position:"Body" name:"Id"`
	AppId       string           `position:"Body" name:"AppId"`
	WorkspaceId string           `position:"Body" name:"WorkspaceId"`
}

// GetUserAppDonwloadUrlInMsaResponse is the response struct for api GetUserAppDonwloadUrlInMsa
type GetUserAppDonwloadUrlInMsaResponse struct {
	*responses.BaseResponse
	ResultMessage string                                    `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                    `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                    `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInGetUserAppDonwloadUrlInMsa `json:"ResultContent" xml:"ResultContent"`
}

// CreateGetUserAppDonwloadUrlInMsaRequest creates a request to invoke GetUserAppDonwloadUrlInMsa API
func CreateGetUserAppDonwloadUrlInMsaRequest() (request *GetUserAppDonwloadUrlInMsaRequest) {
	request = &GetUserAppDonwloadUrlInMsaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "GetUserAppDonwloadUrlInMsa", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserAppDonwloadUrlInMsaResponse creates a response to parse from GetUserAppDonwloadUrlInMsa response
func CreateGetUserAppDonwloadUrlInMsaResponse() (response *GetUserAppDonwloadUrlInMsaResponse) {
	response = &GetUserAppDonwloadUrlInMsaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
