package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMappCenterWorkspaces invokes the mpaas.ListMappCenterWorkspaces API synchronously
func (client *Client) ListMappCenterWorkspaces(request *ListMappCenterWorkspacesRequest) (response *ListMappCenterWorkspacesResponse, err error) {
	response = CreateListMappCenterWorkspacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMappCenterWorkspacesWithChan invokes the mpaas.ListMappCenterWorkspaces API asynchronously
func (client *Client) ListMappCenterWorkspacesWithChan(request *ListMappCenterWorkspacesRequest) (<-chan *ListMappCenterWorkspacesResponse, <-chan error) {
	responseChan := make(chan *ListMappCenterWorkspacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMappCenterWorkspaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMappCenterWorkspacesWithCallback invokes the mpaas.ListMappCenterWorkspaces API asynchronously
func (client *Client) ListMappCenterWorkspacesWithCallback(request *ListMappCenterWorkspacesRequest, callback func(response *ListMappCenterWorkspacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMappCenterWorkspacesResponse
		var err error
		defer close(result)
		response, err = client.ListMappCenterWorkspaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMappCenterWorkspacesRequest is the request struct for api ListMappCenterWorkspaces
type ListMappCenterWorkspacesRequest struct {
	*requests.RpcRequest
}

// ListMappCenterWorkspacesResponse is the response struct for api ListMappCenterWorkspaces
type ListMappCenterWorkspacesResponse struct {
	*responses.BaseResponse
	ResultMessage                 string                        `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode                    string                        `json:"ResultCode" xml:"ResultCode"`
	RequestId                     string                        `json:"RequestId" xml:"RequestId"`
	ListMappCenterWorkspaceResult ListMappCenterWorkspaceResult `json:"ListMappCenterWorkspaceResult" xml:"ListMappCenterWorkspaceResult"`
}

// CreateListMappCenterWorkspacesRequest creates a request to invoke ListMappCenterWorkspaces API
func CreateListMappCenterWorkspacesRequest() (request *ListMappCenterWorkspacesRequest) {
	request = &ListMappCenterWorkspacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "ListMappCenterWorkspaces", "", "")
	request.Method = requests.POST
	return
}

// CreateListMappCenterWorkspacesResponse creates a response to parse from ListMappCenterWorkspaces response
func CreateListMappCenterWorkspacesResponse() (response *ListMappCenterWorkspacesResponse) {
	response = &ListMappCenterWorkspacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
