package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RunMsaDiff invokes the mpaas.RunMsaDiff API synchronously
func (client *Client) RunMsaDiff(request *RunMsaDiffRequest) (response *RunMsaDiffResponse, err error) {
	response = CreateRunMsaDiffResponse()
	err = client.DoAction(request, response)
	return
}

// RunMsaDiffWithChan invokes the mpaas.RunMsaDiff API asynchronously
func (client *Client) RunMsaDiffWithChan(request *RunMsaDiffRequest) (<-chan *RunMsaDiffResponse, <-chan error) {
	responseChan := make(chan *RunMsaDiffResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RunMsaDiff(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RunMsaDiffWithCallback invokes the mpaas.RunMsaDiff API asynchronously
func (client *Client) RunMsaDiffWithCallback(request *RunMsaDiffRequest, callback func(response *RunMsaDiffResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RunMsaDiffResponse
		var err error
		defer close(result)
		response, err = client.RunMsaDiff(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RunMsaDiffRequest is the request struct for api RunMsaDiff
type RunMsaDiffRequest struct {
	*requests.RpcRequest
	TenantId                         string `position:"Body" name:"TenantId"`
	AppId                            string `position:"Body" name:"AppId"`
	MpaasMappcenterMsaDiffRunJsonStr string `position:"Body" name:"MpaasMappcenterMsaDiffRunJsonStr"`
	WorkspaceId                      string `position:"Body" name:"WorkspaceId"`
}

// RunMsaDiffResponse is the response struct for api RunMsaDiff
type RunMsaDiffResponse struct {
	*responses.BaseResponse
	ResultMessage string                    `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                    `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                    `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInRunMsaDiff `json:"ResultContent" xml:"ResultContent"`
}

// CreateRunMsaDiffRequest creates a request to invoke RunMsaDiff API
func CreateRunMsaDiffRequest() (request *RunMsaDiffRequest) {
	request = &RunMsaDiffRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "RunMsaDiff", "", "")
	request.Method = requests.POST
	return
}

// CreateRunMsaDiffResponse creates a response to parse from RunMsaDiff response
func CreateRunMsaDiffResponse() (response *RunMsaDiffResponse) {
	response = &RunMsaDiffResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
