package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCircuitBreakerRule invokes the mse.CreateCircuitBreakerRule API synchronously
func (client *Client) CreateCircuitBreakerRule(request *CreateCircuitBreakerRuleRequest) (response *CreateCircuitBreakerRuleResponse, err error) {
	response = CreateCreateCircuitBreakerRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCircuitBreakerRuleWithChan invokes the mse.CreateCircuitBreakerRule API asynchronously
func (client *Client) CreateCircuitBreakerRuleWithChan(request *CreateCircuitBreakerRuleRequest) (<-chan *CreateCircuitBreakerRuleResponse, <-chan error) {
	responseChan := make(chan *CreateCircuitBreakerRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCircuitBreakerRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCircuitBreakerRuleWithCallback invokes the mse.CreateCircuitBreakerRule API asynchronously
func (client *Client) CreateCircuitBreakerRuleWithCallback(request *CreateCircuitBreakerRuleRequest, callback func(response *CreateCircuitBreakerRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCircuitBreakerRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateCircuitBreakerRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCircuitBreakerRuleRequest is the request struct for api CreateCircuitBreakerRule
type CreateCircuitBreakerRuleRequest struct {
	*requests.RpcRequest
	MseSessionId              string           `position:"Query" name:"MseSessionId"`
	Threshold                 requests.Float   `position:"Query" name:"Threshold"`
	RetryTimeoutMs            requests.Integer `position:"Query" name:"RetryTimeoutMs"`
	AppName                   string           `position:"Query" name:"AppName"`
	Enable                    requests.Boolean `position:"Query" name:"Enable"`
	MinRequestAmount          requests.Integer `position:"Query" name:"MinRequestAmount"`
	Resource                  string           `position:"Query" name:"Resource"`
	MaxAllowedRtMs            requests.Integer `position:"Query" name:"MaxAllowedRtMs"`
	HalfOpenBaseAmountPerStep requests.Integer `position:"Query" name:"HalfOpenBaseAmountPerStep"`
	ResourceType              requests.Integer `position:"Query" name:"ResourceType"`
	StatIntervalMs            requests.Integer `position:"Query" name:"StatIntervalMs"`
	AppId                     string           `position:"Query" name:"AppId"`
	Namespace                 string           `position:"Query" name:"Namespace"`
	HalfOpenRecoveryStepNum   requests.Integer `position:"Query" name:"HalfOpenRecoveryStepNum"`
	AcceptLanguage            string           `position:"Query" name:"AcceptLanguage"`
	Strategy                  requests.Integer `position:"Query" name:"Strategy"`
}

// CreateCircuitBreakerRuleResponse is the response struct for api CreateCircuitBreakerRule
type CreateCircuitBreakerRuleResponse struct {
	*responses.BaseResponse
	Message   string                         `json:"Message" xml:"Message"`
	RequestId string                         `json:"RequestId" xml:"RequestId"`
	Code      string                         `json:"Code" xml:"Code"`
	Success   bool                           `json:"Success" xml:"Success"`
	Data      DataInCreateCircuitBreakerRule `json:"Data" xml:"Data"`
}

// CreateCreateCircuitBreakerRuleRequest creates a request to invoke CreateCircuitBreakerRule API
func CreateCreateCircuitBreakerRuleRequest() (request *CreateCircuitBreakerRuleRequest) {
	request = &CreateCircuitBreakerRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateCircuitBreakerRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCircuitBreakerRuleResponse creates a response to parse from CreateCircuitBreakerRule response
func CreateCreateCircuitBreakerRuleResponse() (response *CreateCircuitBreakerRuleResponse) {
	response = &CreateCircuitBreakerRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
