package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateSwimmingLaneGroup invokes the mse.CreateOrUpdateSwimmingLaneGroup API synchronously
func (client *Client) CreateOrUpdateSwimmingLaneGroup(request *CreateOrUpdateSwimmingLaneGroupRequest) (response *CreateOrUpdateSwimmingLaneGroupResponse, err error) {
	response = CreateCreateOrUpdateSwimmingLaneGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateSwimmingLaneGroupWithChan invokes the mse.CreateOrUpdateSwimmingLaneGroup API asynchronously
func (client *Client) CreateOrUpdateSwimmingLaneGroupWithChan(request *CreateOrUpdateSwimmingLaneGroupRequest) (<-chan *CreateOrUpdateSwimmingLaneGroupResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateSwimmingLaneGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateSwimmingLaneGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateSwimmingLaneGroupWithCallback invokes the mse.CreateOrUpdateSwimmingLaneGroup API asynchronously
func (client *Client) CreateOrUpdateSwimmingLaneGroupWithCallback(request *CreateOrUpdateSwimmingLaneGroupRequest, callback func(response *CreateOrUpdateSwimmingLaneGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateSwimmingLaneGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateSwimmingLaneGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateSwimmingLaneGroupRequest is the request struct for api CreateOrUpdateSwimmingLaneGroup
type CreateOrUpdateSwimmingLaneGroupRequest struct {
	*requests.RpcRequest
	MseSessionId           string           `position:"Query" name:"MseSessionId"`
	AppIds                 string           `position:"Query" name:"AppIds"`
	DbGrayEnable           requests.Boolean `position:"Query" name:"DbGrayEnable"`
	Enable                 requests.Boolean `position:"Query" name:"Enable"`
	SwimVersion            requests.Integer `position:"Query" name:"SwimVersion"`
	Id                     requests.Integer `position:"Query" name:"Id"`
	RouteIds               *[]string        `position:"Query" name:"RouteIds"  type:"Json"`
	CanaryModel            requests.Integer `position:"Query" name:"CanaryModel"`
	Paths                  *[]string        `position:"Query" name:"Paths"  type:"Json"`
	Name                   string           `position:"Query" name:"Name"`
	MessageQueueFilterSide string           `position:"Query" name:"MessageQueueFilterSide"`
	Region                 string           `position:"Query" name:"Region"`
	Status                 requests.Integer `position:"Query" name:"Status"`
	MessageQueueGrayEnable requests.Boolean `position:"Query" name:"MessageQueueGrayEnable"`
	EntryApp               string           `position:"Query" name:"EntryApp"`
	RecordCanaryDetail     requests.Boolean `position:"Query" name:"RecordCanaryDetail"`
	Namespace              string           `position:"Query" name:"Namespace"`
	AcceptLanguage         string           `position:"Query" name:"AcceptLanguage"`
}

// CreateOrUpdateSwimmingLaneGroupResponse is the response struct for api CreateOrUpdateSwimmingLaneGroup
type CreateOrUpdateSwimmingLaneGroupResponse struct {
	*responses.BaseResponse
	RequestId string                                `json:"RequestId" xml:"RequestId"`
	Success   bool                                  `json:"Success" xml:"Success"`
	ErrorCode string                                `json:"ErrorCode" xml:"ErrorCode"`
	Message   string                                `json:"Message" xml:"Message"`
	Data      DataInCreateOrUpdateSwimmingLaneGroup `json:"Data" xml:"Data"`
}

// CreateCreateOrUpdateSwimmingLaneGroupRequest creates a request to invoke CreateOrUpdateSwimmingLaneGroup API
func CreateCreateOrUpdateSwimmingLaneGroupRequest() (request *CreateOrUpdateSwimmingLaneGroupRequest) {
	request = &CreateOrUpdateSwimmingLaneGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateOrUpdateSwimmingLaneGroup", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrUpdateSwimmingLaneGroupResponse creates a response to parse from CreateOrUpdateSwimmingLaneGroup response
func CreateCreateOrUpdateSwimmingLaneGroupResponse() (response *CreateOrUpdateSwimmingLaneGroupResponse) {
	response = &CreateOrUpdateSwimmingLaneGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
