package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePluginConfig invokes the mse.DeletePluginConfig API synchronously
func (client *Client) DeletePluginConfig(request *DeletePluginConfigRequest) (response *DeletePluginConfigResponse, err error) {
	response = CreateDeletePluginConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePluginConfigWithChan invokes the mse.DeletePluginConfig API asynchronously
func (client *Client) DeletePluginConfigWithChan(request *DeletePluginConfigRequest) (<-chan *DeletePluginConfigResponse, <-chan error) {
	responseChan := make(chan *DeletePluginConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePluginConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePluginConfigWithCallback invokes the mse.DeletePluginConfig API asynchronously
func (client *Client) DeletePluginConfigWithCallback(request *DeletePluginConfigRequest, callback func(response *DeletePluginConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePluginConfigResponse
		var err error
		defer close(result)
		response, err = client.DeletePluginConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePluginConfigRequest is the request struct for api DeletePluginConfig
type DeletePluginConfigRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	PluginConfigId  requests.Integer `position:"Query" name:"PluginConfigId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// DeletePluginConfigResponse is the response struct for api DeletePluginConfig
type DeletePluginConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletePluginConfigRequest creates a request to invoke DeletePluginConfig API
func CreateDeletePluginConfigRequest() (request *DeletePluginConfigRequest) {
	request = &DeletePluginConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeletePluginConfig", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletePluginConfigResponse creates a response to parse from DeletePluginConfig response
func CreateDeletePluginConfigResponse() (response *DeletePluginConfigResponse) {
	response = &DeletePluginConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
