package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGatewayConfig invokes the mse.GetGatewayConfig API synchronously
func (client *Client) GetGatewayConfig(request *GetGatewayConfigRequest) (response *GetGatewayConfigResponse, err error) {
	response = CreateGetGatewayConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetGatewayConfigWithChan invokes the mse.GetGatewayConfig API asynchronously
func (client *Client) GetGatewayConfigWithChan(request *GetGatewayConfigRequest) (<-chan *GetGatewayConfigResponse, <-chan error) {
	responseChan := make(chan *GetGatewayConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGatewayConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGatewayConfigWithCallback invokes the mse.GetGatewayConfig API asynchronously
func (client *Client) GetGatewayConfigWithCallback(request *GetGatewayConfigRequest, callback func(response *GetGatewayConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGatewayConfigResponse
		var err error
		defer close(result)
		response, err = client.GetGatewayConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGatewayConfigRequest is the request struct for api GetGatewayConfig
type GetGatewayConfigRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// GetGatewayConfigResponse is the response struct for api GetGatewayConfig
type GetGatewayConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetGatewayConfigRequest creates a request to invoke GetGatewayConfig API
func CreateGetGatewayConfigRequest() (request *GetGatewayConfigRequest) {
	request = &GetGatewayConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "GetGatewayConfig", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetGatewayConfigResponse creates a response to parse from GetGatewayConfig response
func CreateGetGatewayConfigResponse() (response *GetGatewayConfigResponse) {
	response = &GetGatewayConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
