package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIsolationRules invokes the mse.ListIsolationRules API synchronously
func (client *Client) ListIsolationRules(request *ListIsolationRulesRequest) (response *ListIsolationRulesResponse, err error) {
	response = CreateListIsolationRulesResponse()
	err = client.DoAction(request, response)
	return
}

// ListIsolationRulesWithChan invokes the mse.ListIsolationRules API asynchronously
func (client *Client) ListIsolationRulesWithChan(request *ListIsolationRulesRequest) (<-chan *ListIsolationRulesResponse, <-chan error) {
	responseChan := make(chan *ListIsolationRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIsolationRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIsolationRulesWithCallback invokes the mse.ListIsolationRules API asynchronously
func (client *Client) ListIsolationRulesWithCallback(request *ListIsolationRulesRequest, callback func(response *ListIsolationRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIsolationRulesResponse
		var err error
		defer close(result)
		response, err = client.ListIsolationRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIsolationRulesRequest is the request struct for api ListIsolationRules
type ListIsolationRulesRequest struct {
	*requests.RpcRequest
	MseSessionId      string           `position:"Query" name:"MseSessionId"`
	AppName           string           `position:"Query" name:"AppName"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	PageIndex         requests.Integer `position:"Query" name:"PageIndex"`
	Resource          string           `position:"Query" name:"Resource"`
	AppId             string           `position:"Query" name:"AppId"`
	Namespace         string           `position:"Query" name:"Namespace"`
	AcceptLanguage    string           `position:"Query" name:"AcceptLanguage"`
	ResourceSearchKey string           `position:"Query" name:"ResourceSearchKey"`
}

// ListIsolationRulesResponse is the response struct for api ListIsolationRules
type ListIsolationRulesResponse struct {
	*responses.BaseResponse
	Code           int    `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListIsolationRulesRequest creates a request to invoke ListIsolationRules API
func CreateListIsolationRulesRequest() (request *ListIsolationRulesRequest) {
	request = &ListIsolationRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListIsolationRules", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIsolationRulesResponse creates a response to parse from ListIsolationRules response
func CreateListIsolationRulesResponse() (response *ListIsolationRulesResponse) {
	response = &ListIsolationRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
