package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateGatewayRouteRetry invokes the mse.UpdateGatewayRouteRetry API synchronously
func (client *Client) UpdateGatewayRouteRetry(request *UpdateGatewayRouteRetryRequest) (response *UpdateGatewayRouteRetryResponse, err error) {
	response = CreateUpdateGatewayRouteRetryResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateGatewayRouteRetryWithChan invokes the mse.UpdateGatewayRouteRetry API asynchronously
func (client *Client) UpdateGatewayRouteRetryWithChan(request *UpdateGatewayRouteRetryRequest) (<-chan *UpdateGatewayRouteRetryResponse, <-chan error) {
	responseChan := make(chan *UpdateGatewayRouteRetryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateGatewayRouteRetry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateGatewayRouteRetryWithCallback invokes the mse.UpdateGatewayRouteRetry API asynchronously
func (client *Client) UpdateGatewayRouteRetryWithCallback(request *UpdateGatewayRouteRetryRequest, callback func(response *UpdateGatewayRouteRetryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateGatewayRouteRetryResponse
		var err error
		defer close(result)
		response, err = client.UpdateGatewayRouteRetry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateGatewayRouteRetryRequest is the request struct for api UpdateGatewayRouteRetry
type UpdateGatewayRouteRetryRequest struct {
	*requests.RpcRequest
	MseSessionId    string                           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string                           `position:"Query" name:"GatewayUniqueId"`
	RetryJSON       UpdateGatewayRouteRetryRetryJSON `position:"Query" name:"RetryJSON"  type:"Struct"`
	Id              requests.Integer                 `position:"Query" name:"Id"`
	GatewayId       requests.Integer                 `position:"Query" name:"GatewayId"`
	AcceptLanguage  string                           `position:"Query" name:"AcceptLanguage"`
}

// UpdateGatewayRouteRetryRetryJSON is a repeated param struct in UpdateGatewayRouteRetryRequest
type UpdateGatewayRouteRetryRetryJSON struct {
	HttpCodes *[]string `name:"HttpCodes" type:"Repeated"`
	Attempts  string    `name:"Attempts"`
	RetryOn   *[]string `name:"RetryOn" type:"Repeated"`
	Status    string    `name:"Status"`
}

// UpdateGatewayRouteRetryResponse is the response struct for api UpdateGatewayRouteRetry
type UpdateGatewayRouteRetryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateUpdateGatewayRouteRetryRequest creates a request to invoke UpdateGatewayRouteRetry API
func CreateUpdateGatewayRouteRetryRequest() (request *UpdateGatewayRouteRetryRequest) {
	request = &UpdateGatewayRouteRetryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateGatewayRouteRetry", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateGatewayRouteRetryResponse creates a response to parse from UpdateGatewayRouteRetry response
func CreateUpdateGatewayRouteRetryResponse() (response *UpdateGatewayRouteRetryResponse) {
	response = &UpdateGatewayRouteRetryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
