package mseap

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CallbackTask invokes the mseap.CallbackTask API synchronously
func (client *Client) CallbackTask(request *CallbackTaskRequest) (response *CallbackTaskResponse, err error) {
	response = CreateCallbackTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CallbackTaskWithChan invokes the mseap.CallbackTask API asynchronously
func (client *Client) CallbackTaskWithChan(request *CallbackTaskRequest) (<-chan *CallbackTaskResponse, <-chan error) {
	responseChan := make(chan *CallbackTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CallbackTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CallbackTaskWithCallback invokes the mseap.CallbackTask API asynchronously
func (client *Client) CallbackTaskWithCallback(request *CallbackTaskRequest, callback func(response *CallbackTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CallbackTaskResponse
		var err error
		defer close(result)
		response, err = client.CallbackTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CallbackTaskRequest is the request struct for api CallbackTask
type CallbackTaskRequest struct {
	*requests.RpcRequest
	UserCallerParentId          requests.Integer `position:"Query" name:"UserCallerParentId"`
	OutTaskId                   string           `position:"Query" name:"OutTaskId"`
	ApiType                     string           `position:"Query" name:"ApiType"`
	UserMfaPresent              requests.Boolean `position:"Query" name:"UserMfaPresent"`
	UserKp                      string           `position:"Query" name:"UserKp"`
	Lang                        string           `position:"Query" name:"Lang"`
	TaskId                      string           `position:"Query" name:"TaskId"`
	UserCallerType              string           `position:"Query" name:"UserCallerType"`
	TaskType                    string           `position:"Query" name:"TaskType"`
	UserSecurityToken           string           `position:"Query" name:"UserSecurityToken"`
	UserAccessKeyId             string           `position:"Query" name:"UserAccessKeyId"`
	OrderId                     string           `position:"Query" name:"OrderId"`
	AliyunKp                    string           `position:"Query" name:"AliyunKp"`
	UserBid                     string           `position:"Query" name:"UserBid"`
	OriginalRequest             string           `position:"Query" name:"OriginalRequest"`
	PrincipalKey                string           `position:"Query" name:"PrincipalKey"`
	UserCallerSecurityTransport requests.Boolean `position:"Query" name:"UserCallerSecurityTransport"`
	BizCode                     string           `position:"Query" name:"BizCode"`
	UserClientIp                string           `position:"Query" name:"UserClientIp"`
	TaskData                    string           `position:"Query" name:"TaskData"`
	Bid                         string           `position:"Query" name:"Bid"`
}

// CallbackTaskResponse is the response struct for api CallbackTask
type CallbackTaskResponse struct {
	*responses.BaseResponse
	AllowRetry     bool   `json:"AllowRetry" xml:"AllowRetry"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Module         bool   `json:"Module" xml:"Module"`
	Success        bool   `json:"Success" xml:"Success"`
	AppName        string `json:"AppName" xml:"AppName"`
}

// CreateCallbackTaskRequest creates a request to invoke CallbackTask API
func CreateCallbackTaskRequest() (request *CallbackTaskRequest) {
	request = &CallbackTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mseap", "2021-01-18", "CallbackTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCallbackTaskResponse creates a response to parse from CallbackTask response
func CreateCallbackTaskResponse() (response *CallbackTaskResponse) {
	response = &CallbackTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
