package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProtocolMountTarget invokes the nas.DeleteProtocolMountTarget API synchronously
func (client *Client) DeleteProtocolMountTarget(request *DeleteProtocolMountTargetRequest) (response *DeleteProtocolMountTargetResponse, err error) {
	response = CreateDeleteProtocolMountTargetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProtocolMountTargetWithChan invokes the nas.DeleteProtocolMountTarget API asynchronously
func (client *Client) DeleteProtocolMountTargetWithChan(request *DeleteProtocolMountTargetRequest) (<-chan *DeleteProtocolMountTargetResponse, <-chan error) {
	responseChan := make(chan *DeleteProtocolMountTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProtocolMountTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProtocolMountTargetWithCallback invokes the nas.DeleteProtocolMountTarget API asynchronously
func (client *Client) DeleteProtocolMountTargetWithCallback(request *DeleteProtocolMountTargetRequest, callback func(response *DeleteProtocolMountTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProtocolMountTargetResponse
		var err error
		defer close(result)
		response, err = client.DeleteProtocolMountTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProtocolMountTargetRequest is the request struct for api DeleteProtocolMountTarget
type DeleteProtocolMountTargetRequest struct {
	*requests.RpcRequest
	ProtocolServiceId string           `position:"Query" name:"ProtocolServiceId"`
	ClientToken       string           `position:"Query" name:"ClientToken"`
	FileSystemId      string           `position:"Query" name:"FileSystemId"`
	DryRun            requests.Boolean `position:"Query" name:"DryRun"`
	ExportId          string           `position:"Query" name:"ExportId"`
}

// DeleteProtocolMountTargetResponse is the response struct for api DeleteProtocolMountTarget
type DeleteProtocolMountTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProtocolMountTargetRequest creates a request to invoke DeleteProtocolMountTarget API
func CreateDeleteProtocolMountTargetRequest() (request *DeleteProtocolMountTargetRequest) {
	request = &DeleteProtocolMountTargetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DeleteProtocolMountTarget", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteProtocolMountTargetResponse creates a response to parse from DeleteProtocolMountTarget response
func CreateDeleteProtocolMountTargetResponse() (response *DeleteProtocolMountTargetResponse) {
	response = &DeleteProtocolMountTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
