package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeProcessStatsComposition invokes the oceanbasepro.DescribeProcessStatsComposition API synchronously
func (client *Client) DescribeProcessStatsComposition(request *DescribeProcessStatsCompositionRequest) (response *DescribeProcessStatsCompositionResponse, err error) {
	response = CreateDescribeProcessStatsCompositionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeProcessStatsCompositionWithChan invokes the oceanbasepro.DescribeProcessStatsComposition API asynchronously
func (client *Client) DescribeProcessStatsCompositionWithChan(request *DescribeProcessStatsCompositionRequest) (<-chan *DescribeProcessStatsCompositionResponse, <-chan error) {
	responseChan := make(chan *DescribeProcessStatsCompositionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeProcessStatsComposition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeProcessStatsCompositionWithCallback invokes the oceanbasepro.DescribeProcessStatsComposition API asynchronously
func (client *Client) DescribeProcessStatsCompositionWithCallback(request *DescribeProcessStatsCompositionRequest, callback func(response *DescribeProcessStatsCompositionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeProcessStatsCompositionResponse
		var err error
		defer close(result)
		response, err = client.DescribeProcessStatsComposition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeProcessStatsCompositionRequest is the request struct for api DescribeProcessStatsComposition
type DescribeProcessStatsCompositionRequest struct {
	*requests.RpcRequest
	UId        string `position:"Body" name:"UId"`
	SqlText    string `position:"Body" name:"SqlText"`
	ClientIp   string `position:"Body" name:"ClientIp"`
	TenantId   string `position:"Body" name:"TenantId"`
	ServerIp   string `position:"Body" name:"ServerIp"`
	Users      string `position:"Body" name:"Users"`
	InstanceId string `position:"Body" name:"InstanceId"`
	Status     string `position:"Body" name:"Status"`
}

// DescribeProcessStatsCompositionResponse is the response struct for api DescribeProcessStatsComposition
type DescribeProcessStatsCompositionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeProcessStatsCompositionRequest creates a request to invoke DescribeProcessStatsComposition API
func CreateDescribeProcessStatsCompositionRequest() (request *DescribeProcessStatsCompositionRequest) {
	request = &DescribeProcessStatsCompositionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeProcessStatsComposition", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeProcessStatsCompositionResponse creates a response to parse from DescribeProcessStatsComposition response
func CreateDescribeProcessStatsCompositionResponse() (response *DescribeProcessStatsCompositionResponse) {
	response = &DescribeProcessStatsCompositionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
