package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRestorableTenants invokes the oceanbasepro.DescribeRestorableTenants API synchronously
func (client *Client) DescribeRestorableTenants(request *DescribeRestorableTenantsRequest) (response *DescribeRestorableTenantsResponse, err error) {
	response = CreateDescribeRestorableTenantsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRestorableTenantsWithChan invokes the oceanbasepro.DescribeRestorableTenants API asynchronously
func (client *Client) DescribeRestorableTenantsWithChan(request *DescribeRestorableTenantsRequest) (<-chan *DescribeRestorableTenantsResponse, <-chan error) {
	responseChan := make(chan *DescribeRestorableTenantsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRestorableTenants(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRestorableTenantsWithCallback invokes the oceanbasepro.DescribeRestorableTenants API asynchronously
func (client *Client) DescribeRestorableTenantsWithCallback(request *DescribeRestorableTenantsRequest, callback func(response *DescribeRestorableTenantsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRestorableTenantsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRestorableTenants(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRestorableTenantsRequest is the request struct for api DescribeRestorableTenants
type DescribeRestorableTenantsRequest struct {
	*requests.RpcRequest
	RestoreMode       string           `position:"Body" name:"RestoreMode"`
	RestoreObjectType string           `position:"Body" name:"RestoreObjectType"`
	IsOnline          requests.Boolean `position:"Body" name:"IsOnline"`
	IsRemote          requests.Boolean `position:"Body" name:"IsRemote"`
	Method            string           `position:"Body" name:"Method"`
	InstanceId        string           `position:"Body" name:"InstanceId"`
	SetId             string           `position:"Body" name:"SetId"`
}

// DescribeRestorableTenantsResponse is the response struct for api DescribeRestorableTenants
type DescribeRestorableTenantsResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Tenants    []Data `json:"Tenants" xml:"Tenants"`
}

// CreateDescribeRestorableTenantsRequest creates a request to invoke DescribeRestorableTenants API
func CreateDescribeRestorableTenantsRequest() (request *DescribeRestorableTenantsRequest) {
	request = &DescribeRestorableTenantsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeRestorableTenants", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRestorableTenantsResponse creates a response to parse from DescribeRestorableTenants response
func CreateDescribeRestorableTenantsResponse() (response *DescribeRestorableTenantsResponse) {
	response = &DescribeRestorableTenantsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
