package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectFullVerifyResult invokes the oceanbasepro.ListProjectFullVerifyResult API synchronously
func (client *Client) ListProjectFullVerifyResult(request *ListProjectFullVerifyResultRequest) (response *ListProjectFullVerifyResultResponse, err error) {
	response = CreateListProjectFullVerifyResultResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectFullVerifyResultWithChan invokes the oceanbasepro.ListProjectFullVerifyResult API asynchronously
func (client *Client) ListProjectFullVerifyResultWithChan(request *ListProjectFullVerifyResultRequest) (<-chan *ListProjectFullVerifyResultResponse, <-chan error) {
	responseChan := make(chan *ListProjectFullVerifyResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectFullVerifyResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectFullVerifyResultWithCallback invokes the oceanbasepro.ListProjectFullVerifyResult API asynchronously
func (client *Client) ListProjectFullVerifyResultWithCallback(request *ListProjectFullVerifyResultRequest, callback func(response *ListProjectFullVerifyResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectFullVerifyResultResponse
		var err error
		defer close(result)
		response, err = client.ListProjectFullVerifyResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectFullVerifyResultRequest is the request struct for api ListProjectFullVerifyResult
type ListProjectFullVerifyResultRequest struct {
	*requests.RpcRequest
	DestSchemas   *[]string        `position:"Body" name:"DestSchemas"  type:"Json"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	SourceSchemas *[]string        `position:"Body" name:"SourceSchemas"  type:"Json"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
	Status        string           `position:"Body" name:"Status"`
}

// ListProjectFullVerifyResultResponse is the response struct for api ListProjectFullVerifyResult
type ListProjectFullVerifyResultResponse struct {
	*responses.BaseResponse
}

// CreateListProjectFullVerifyResultRequest creates a request to invoke ListProjectFullVerifyResult API
func CreateListProjectFullVerifyResultRequest() (request *ListProjectFullVerifyResultRequest) {
	request = &ListProjectFullVerifyResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ListProjectFullVerifyResult", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProjectFullVerifyResultResponse creates a response to parse from ListProjectFullVerifyResult response
func CreateListProjectFullVerifyResultResponse() (response *ListProjectFullVerifyResultResponse) {
	response = &ListProjectFullVerifyResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
