package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelExecution invokes the oos.CancelExecution API synchronously
func (client *Client) CancelExecution(request *CancelExecutionRequest) (response *CancelExecutionResponse, err error) {
	response = CreateCancelExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// CancelExecutionWithChan invokes the oos.CancelExecution API asynchronously
func (client *Client) CancelExecutionWithChan(request *CancelExecutionRequest) (<-chan *CancelExecutionResponse, <-chan error) {
	responseChan := make(chan *CancelExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelExecutionWithCallback invokes the oos.CancelExecution API asynchronously
func (client *Client) CancelExecutionWithCallback(request *CancelExecutionRequest, callback func(response *CancelExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelExecutionResponse
		var err error
		defer close(result)
		response, err = client.CancelExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelExecutionRequest is the request struct for api CancelExecution
type CancelExecutionRequest struct {
	*requests.RpcRequest
	ExecutionId string `position:"Query" name:"ExecutionId"`
}

// CancelExecutionResponse is the response struct for api CancelExecution
type CancelExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelExecutionRequest creates a request to invoke CancelExecution API
func CreateCancelExecutionRequest() (request *CancelExecutionRequest) {
	request = &CancelExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "CancelExecution", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelExecutionResponse creates a response to parse from CancelExecution response
func CreateCancelExecutionResponse() (response *CancelExecutionResponse) {
	response = &CancelExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
