package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationGroupBill invokes the oos.DescribeApplicationGroupBill API synchronously
func (client *Client) DescribeApplicationGroupBill(request *DescribeApplicationGroupBillRequest) (response *DescribeApplicationGroupBillResponse, err error) {
	response = CreateDescribeApplicationGroupBillResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationGroupBillWithChan invokes the oos.DescribeApplicationGroupBill API asynchronously
func (client *Client) DescribeApplicationGroupBillWithChan(request *DescribeApplicationGroupBillRequest) (<-chan *DescribeApplicationGroupBillResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationGroupBillResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationGroupBill(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationGroupBillWithCallback invokes the oos.DescribeApplicationGroupBill API asynchronously
func (client *Client) DescribeApplicationGroupBillWithCallback(request *DescribeApplicationGroupBillRequest, callback func(response *DescribeApplicationGroupBillResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationGroupBillResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationGroupBill(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationGroupBillRequest is the request struct for api DescribeApplicationGroupBill
type DescribeApplicationGroupBillRequest struct {
	*requests.RpcRequest
	NextToken       string           `position:"Query" name:"NextToken"`
	BillingCycle    string           `position:"Query" name:"BillingCycle"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	ApplicationName string           `position:"Query" name:"ApplicationName"`
	Name            string           `position:"Query" name:"Name"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeApplicationGroupBillResponse is the response struct for api DescribeApplicationGroupBill
type DescribeApplicationGroupBillResponse struct {
	*responses.BaseResponse
	NextToken               string                        `json:"NextToken" xml:"NextToken"`
	RequestId               string                        `json:"RequestId" xml:"RequestId"`
	MaxResults              int                           `json:"MaxResults" xml:"MaxResults"`
	ApplicationGroupConsume []ApplicationGroupConsumeItem `json:"ApplicationGroupConsume" xml:"ApplicationGroupConsume"`
}

// CreateDescribeApplicationGroupBillRequest creates a request to invoke DescribeApplicationGroupBill API
func CreateDescribeApplicationGroupBillRequest() (request *DescribeApplicationGroupBillRequest) {
	request = &DescribeApplicationGroupBillRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "DescribeApplicationGroupBill", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApplicationGroupBillResponse creates a response to parse from DescribeApplicationGroupBill response
func CreateDescribeApplicationGroupBillResponse() (response *DescribeApplicationGroupBillResponse) {
	response = &DescribeApplicationGroupBillResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
