package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetParameter invokes the oos.GetParameter API synchronously
func (client *Client) GetParameter(request *GetParameterRequest) (response *GetParameterResponse, err error) {
	response = CreateGetParameterResponse()
	err = client.DoAction(request, response)
	return
}

// GetParameterWithChan invokes the oos.GetParameter API asynchronously
func (client *Client) GetParameterWithChan(request *GetParameterRequest) (<-chan *GetParameterResponse, <-chan error) {
	responseChan := make(chan *GetParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetParameterWithCallback invokes the oos.GetParameter API asynchronously
func (client *Client) GetParameterWithCallback(request *GetParameterRequest, callback func(response *GetParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetParameterResponse
		var err error
		defer close(result)
		response, err = client.GetParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetParameterRequest is the request struct for api GetParameter
type GetParameterRequest struct {
	*requests.RpcRequest
	ResourceGroupId  string           `position:"Query" name:"ResourceGroupId"`
	ParameterVersion requests.Integer `position:"Query" name:"ParameterVersion"`
	Name             string           `position:"Query" name:"Name"`
}

// GetParameterResponse is the response struct for api GetParameter
type GetParameterResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Parameter Parameter `json:"Parameter" xml:"Parameter"`
}

// CreateGetParameterRequest creates a request to invoke GetParameter API
func CreateGetParameterRequest() (request *GetParameterRequest) {
	request = &GetParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetParameter", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetParameterResponse creates a response to parse from GetParameter response
func CreateGetParameterResponse() (response *GetParameterResponse) {
	response = &GetParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
