package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceExecutionStatus invokes the oos.ListResourceExecutionStatus API synchronously
func (client *Client) ListResourceExecutionStatus(request *ListResourceExecutionStatusRequest) (response *ListResourceExecutionStatusResponse, err error) {
	response = CreateListResourceExecutionStatusResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceExecutionStatusWithChan invokes the oos.ListResourceExecutionStatus API asynchronously
func (client *Client) ListResourceExecutionStatusWithChan(request *ListResourceExecutionStatusRequest) (<-chan *ListResourceExecutionStatusResponse, <-chan error) {
	responseChan := make(chan *ListResourceExecutionStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceExecutionStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceExecutionStatusWithCallback invokes the oos.ListResourceExecutionStatus API asynchronously
func (client *Client) ListResourceExecutionStatusWithCallback(request *ListResourceExecutionStatusRequest, callback func(response *ListResourceExecutionStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceExecutionStatusResponse
		var err error
		defer close(result)
		response, err = client.ListResourceExecutionStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceExecutionStatusRequest is the request struct for api ListResourceExecutionStatus
type ListResourceExecutionStatusRequest struct {
	*requests.RpcRequest
	ExecutionId string           `position:"Query" name:"ExecutionId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// ListResourceExecutionStatusResponse is the response struct for api ListResourceExecutionStatus
type ListResourceExecutionStatusResponse struct {
	*responses.BaseResponse
	NextToken               string   `json:"NextToken" xml:"NextToken"`
	RequestId               string   `json:"RequestId" xml:"RequestId"`
	MaxResults              int      `json:"MaxResults" xml:"MaxResults"`
	ResourceExecutionStatus []Status `json:"ResourceExecutionStatus" xml:"ResourceExecutionStatus"`
}

// CreateListResourceExecutionStatusRequest creates a request to invoke ListResourceExecutionStatus API
func CreateListResourceExecutionStatusRequest() (request *ListResourceExecutionStatusRequest) {
	request = &ListResourceExecutionStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListResourceExecutionStatus", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourceExecutionStatusResponse creates a response to parse from ListResourceExecutionStatus response
func CreateListResourceExecutionStatusResponse() (response *ListResourceExecutionStatusResponse) {
	response = &ListResourceExecutionStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
