package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDialogueFlows invokes the outboundbot.ListDialogueFlows API synchronously
func (client *Client) ListDialogueFlows(request *ListDialogueFlowsRequest) (response *ListDialogueFlowsResponse, err error) {
	response = CreateListDialogueFlowsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDialogueFlowsWithChan invokes the outboundbot.ListDialogueFlows API asynchronously
func (client *Client) ListDialogueFlowsWithChan(request *ListDialogueFlowsRequest) (<-chan *ListDialogueFlowsResponse, <-chan error) {
	responseChan := make(chan *ListDialogueFlowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDialogueFlows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDialogueFlowsWithCallback invokes the outboundbot.ListDialogueFlows API asynchronously
func (client *Client) ListDialogueFlowsWithCallback(request *ListDialogueFlowsRequest, callback func(response *ListDialogueFlowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDialogueFlowsResponse
		var err error
		defer close(result)
		response, err = client.ListDialogueFlows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDialogueFlowsRequest is the request struct for api ListDialogueFlows
type ListDialogueFlowsRequest struct {
	*requests.RpcRequest
	ScriptId   string `position:"Query" name:"ScriptId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ListDialogueFlowsResponse is the response struct for api ListDialogueFlows
type ListDialogueFlowsResponse struct {
	*responses.BaseResponse
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	DialogueFlows  []DialogueFlow `json:"DialogueFlows" xml:"DialogueFlows"`
}

// CreateListDialogueFlowsRequest creates a request to invoke ListDialogueFlows API
func CreateListDialogueFlowsRequest() (request *ListDialogueFlowsRequest) {
	request = &ListDialogueFlowsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListDialogueFlows", "", "")
	request.Method = requests.POST
	return
}

// CreateListDialogueFlowsResponse creates a response to parse from ListDialogueFlows response
func CreateListDialogueFlowsResponse() (response *ListDialogueFlowsResponse) {
	response = &ListDialogueFlowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
