package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateModelFeature invokes the paifeaturestore.CreateModelFeature API synchronously
func (client *Client) CreateModelFeature(request *CreateModelFeatureRequest) (response *CreateModelFeatureResponse, err error) {
	response = CreateCreateModelFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// CreateModelFeatureWithChan invokes the paifeaturestore.CreateModelFeature API asynchronously
func (client *Client) CreateModelFeatureWithChan(request *CreateModelFeatureRequest) (<-chan *CreateModelFeatureResponse, <-chan error) {
	responseChan := make(chan *CreateModelFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateModelFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateModelFeatureWithCallback invokes the paifeaturestore.CreateModelFeature API asynchronously
func (client *Client) CreateModelFeatureWithCallback(request *CreateModelFeatureRequest, callback func(response *CreateModelFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateModelFeatureResponse
		var err error
		defer close(result)
		response, err = client.CreateModelFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateModelFeatureRequest is the request struct for api CreateModelFeature
type CreateModelFeatureRequest struct {
	*requests.RoaRequest
	Body       string `position:"Body" name:"body"`
	InstanceId string `position:"Path" name:"InstanceId"`
}

// CreateModelFeatureResponse is the response struct for api CreateModelFeature
type CreateModelFeatureResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ModelFeatureId string `json:"ModelFeatureId" xml:"ModelFeatureId"`
}

// CreateCreateModelFeatureRequest creates a request to invoke CreateModelFeature API
func CreateCreateModelFeatureRequest() (request *CreateModelFeatureRequest) {
	request = &CreateModelFeatureRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "CreateModelFeature", "/api/v1/instances/[InstanceId]/modelfeatures", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateModelFeatureResponse creates a response to parse from CreateModelFeature response
func CreateCreateModelFeatureResponse() (response *CreateModelFeatureResponse) {
	response = &CreateModelFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
