package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureViewRelationships invokes the paifeaturestore.ListFeatureViewRelationships API synchronously
func (client *Client) ListFeatureViewRelationships(request *ListFeatureViewRelationshipsRequest) (response *ListFeatureViewRelationshipsResponse, err error) {
	response = CreateListFeatureViewRelationshipsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureViewRelationshipsWithChan invokes the paifeaturestore.ListFeatureViewRelationships API asynchronously
func (client *Client) ListFeatureViewRelationshipsWithChan(request *ListFeatureViewRelationshipsRequest) (<-chan *ListFeatureViewRelationshipsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureViewRelationshipsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureViewRelationships(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureViewRelationshipsWithCallback invokes the paifeaturestore.ListFeatureViewRelationships API asynchronously
func (client *Client) ListFeatureViewRelationshipsWithCallback(request *ListFeatureViewRelationshipsRequest, callback func(response *ListFeatureViewRelationshipsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureViewRelationshipsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureViewRelationships(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureViewRelationshipsRequest is the request struct for api ListFeatureViewRelationships
type ListFeatureViewRelationshipsRequest struct {
	*requests.RoaRequest
	InstanceId    string `position:"Path" name:"InstanceId"`
	FeatureViewId string `position:"Path" name:"FeatureViewId"`
}

// ListFeatureViewRelationshipsResponse is the response struct for api ListFeatureViewRelationships
type ListFeatureViewRelationshipsResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	Relationships []RelationshipsItem `json:"Relationships" xml:"Relationships"`
}

// CreateListFeatureViewRelationshipsRequest creates a request to invoke ListFeatureViewRelationships API
func CreateListFeatureViewRelationshipsRequest() (request *ListFeatureViewRelationshipsRequest) {
	request = &ListFeatureViewRelationshipsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListFeatureViewRelationships", "/api/v1/instances/[InstanceId]/featureviews/[FeatureViewId]/relationships", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureViewRelationshipsResponse creates a response to parse from ListFeatureViewRelationships response
func CreateListFeatureViewRelationshipsResponse() (response *ListFeatureViewRelationshipsResponse) {
	response = &ListFeatureViewRelationshipsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
