package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTrafficControlTask invokes the pairecservice.DeleteTrafficControlTask API synchronously
func (client *Client) DeleteTrafficControlTask(request *DeleteTrafficControlTaskRequest) (response *DeleteTrafficControlTaskResponse, err error) {
	response = CreateDeleteTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTrafficControlTaskWithChan invokes the pairecservice.DeleteTrafficControlTask API asynchronously
func (client *Client) DeleteTrafficControlTaskWithChan(request *DeleteTrafficControlTaskRequest) (<-chan *DeleteTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTrafficControlTaskWithCallback invokes the pairecservice.DeleteTrafficControlTask API asynchronously
func (client *Client) DeleteTrafficControlTaskWithCallback(request *DeleteTrafficControlTaskRequest, callback func(response *DeleteTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTrafficControlTaskRequest is the request struct for api DeleteTrafficControlTask
type DeleteTrafficControlTaskRequest struct {
	*requests.RoaRequest
	TrafficControlTaskId string `position:"Path" name:"TrafficControlTaskId"`
	InstanceId           string `position:"Query" name:"InstanceId"`
}

// DeleteTrafficControlTaskResponse is the response struct for api DeleteTrafficControlTask
type DeleteTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTrafficControlTaskRequest creates a request to invoke DeleteTrafficControlTask API
func CreateDeleteTrafficControlTaskRequest() (request *DeleteTrafficControlTaskRequest) {
	request = &DeleteTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteTrafficControlTask", "/api/v1/trafficcontroltasks/[TrafficControlTaskId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteTrafficControlTaskResponse creates a response to parse from DeleteTrafficControlTask response
func CreateDeleteTrafficControlTaskResponse() (response *DeleteTrafficControlTaskResponse) {
	response = &DeleteTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
