package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLaboratory invokes the pairecservice.GetLaboratory API synchronously
func (client *Client) GetLaboratory(request *GetLaboratoryRequest) (response *GetLaboratoryResponse, err error) {
	response = CreateGetLaboratoryResponse()
	err = client.DoAction(request, response)
	return
}

// GetLaboratoryWithChan invokes the pairecservice.GetLaboratory API asynchronously
func (client *Client) GetLaboratoryWithChan(request *GetLaboratoryRequest) (<-chan *GetLaboratoryResponse, <-chan error) {
	responseChan := make(chan *GetLaboratoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLaboratory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLaboratoryWithCallback invokes the pairecservice.GetLaboratory API asynchronously
func (client *Client) GetLaboratoryWithCallback(request *GetLaboratoryRequest, callback func(response *GetLaboratoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLaboratoryResponse
		var err error
		defer close(result)
		response, err = client.GetLaboratory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLaboratoryRequest is the request struct for api GetLaboratory
type GetLaboratoryRequest struct {
	*requests.RoaRequest
	LaboratoryId string `position:"Path" name:"LaboratoryId"`
	InstanceId   string `position:"Query" name:"InstanceId"`
}

// GetLaboratoryResponse is the response struct for api GetLaboratory
type GetLaboratoryResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	SceneId      string `json:"SceneId" xml:"SceneId"`
	Name         string `json:"Name" xml:"Name"`
	Description  string `json:"Description" xml:"Description"`
	DebugUsers   string `json:"DebugUsers" xml:"DebugUsers"`
	DebugCrowdId string `json:"DebugCrowdId" xml:"DebugCrowdId"`
	BucketCount  int    `json:"BucketCount" xml:"BucketCount"`
	Buckets      string `json:"Buckets" xml:"Buckets"`
	BucketType   string `json:"BucketType" xml:"BucketType"`
	Filter       string `json:"Filter" xml:"Filter"`
	Environment  string `json:"Environment" xml:"Environment"`
	Type         string `json:"Type" xml:"Type"`
	Status       string `json:"Status" xml:"Status"`
	CrowdId      string `json:"CrowdId" xml:"CrowdId"`
}

// CreateGetLaboratoryRequest creates a request to invoke GetLaboratory API
func CreateGetLaboratoryRequest() (request *GetLaboratoryRequest) {
	request = &GetLaboratoryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetLaboratory", "/api/v1/laboratories/[LaboratoryId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetLaboratoryResponse creates a response to parse from GetLaboratory response
func CreateGetLaboratoryResponse() (response *GetLaboratoryResponse) {
	response = &GetLaboratoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
