package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResourceRule invokes the pairecservice.GetResourceRule API synchronously
func (client *Client) GetResourceRule(request *GetResourceRuleRequest) (response *GetResourceRuleResponse, err error) {
	response = CreateGetResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetResourceRuleWithChan invokes the pairecservice.GetResourceRule API asynchronously
func (client *Client) GetResourceRuleWithChan(request *GetResourceRuleRequest) (<-chan *GetResourceRuleResponse, <-chan error) {
	responseChan := make(chan *GetResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResourceRuleWithCallback invokes the pairecservice.GetResourceRule API asynchronously
func (client *Client) GetResourceRuleWithCallback(request *GetResourceRuleRequest, callback func(response *GetResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.GetResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResourceRuleRequest is the request struct for api GetResourceRule
type GetResourceRuleRequest struct {
	*requests.RoaRequest
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
}

// GetResourceRuleResponse is the response struct for api GetResourceRule
type GetResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId               string          `json:"RequestId" xml:"RequestId"`
	ResourceRuleId          string          `json:"ResourceRuleId" xml:"ResourceRuleId"`
	Name                    string          `json:"Name" xml:"Name"`
	Description             string          `json:"Description" xml:"Description"`
	MetricOperationType     string          `json:"MetricOperationType" xml:"MetricOperationType"`
	MetricPullInfo          string          `json:"MetricPullInfo" xml:"MetricPullInfo"`
	MetricPullPeriod        string          `json:"MetricPullPeriod" xml:"MetricPullPeriod"`
	RuleComputingDefinition string          `json:"RuleComputingDefinition" xml:"RuleComputingDefinition"`
	RuleItems               []RuleItemsItem `json:"RuleItems" xml:"RuleItems"`
}

// CreateGetResourceRuleRequest creates a request to invoke GetResourceRule API
func CreateGetResourceRuleRequest() (request *GetResourceRuleRequest) {
	request = &GetResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetResourceRule", "/api/v1/resourcerules/[ResourceRuleId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetResourceRuleResponse creates a response to parse from GetResourceRule response
func CreateGetResourceRuleResponse() (response *GetResourceRuleResponse) {
	response = &GetResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
