package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadRecommendationData invokes the pairecservice.UploadRecommendationData API synchronously
func (client *Client) UploadRecommendationData(request *UploadRecommendationDataRequest) (response *UploadRecommendationDataResponse, err error) {
	response = CreateUploadRecommendationDataResponse()
	err = client.DoAction(request, response)
	return
}

// UploadRecommendationDataWithChan invokes the pairecservice.UploadRecommendationData API asynchronously
func (client *Client) UploadRecommendationDataWithChan(request *UploadRecommendationDataRequest) (<-chan *UploadRecommendationDataResponse, <-chan error) {
	responseChan := make(chan *UploadRecommendationDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadRecommendationData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadRecommendationDataWithCallback invokes the pairecservice.UploadRecommendationData API asynchronously
func (client *Client) UploadRecommendationDataWithCallback(request *UploadRecommendationDataRequest, callback func(response *UploadRecommendationDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadRecommendationDataResponse
		var err error
		defer close(result)
		response, err = client.UploadRecommendationData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadRecommendationDataRequest is the request struct for api UploadRecommendationData
type UploadRecommendationDataRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// UploadRecommendationDataResponse is the response struct for api UploadRecommendationData
type UploadRecommendationDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUploadRecommendationDataRequest creates a request to invoke UploadRecommendationData API
func CreateUploadRecommendationDataRequest() (request *UploadRecommendationDataRequest) {
	request = &UploadRecommendationDataRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UploadRecommendationData", "/api/v1/recommendationdata/action/upload", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadRecommendationDataResponse creates a response to parse from UploadRecommendationData response
func CreateUploadRecommendationDataResponse() (response *UploadRecommendationDataResponse) {
	response = &UploadRecommendationDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
