package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBClustersWithBackups invokes the polardb.DescribeDBClustersWithBackups API synchronously
func (client *Client) DescribeDBClustersWithBackups(request *DescribeDBClustersWithBackupsRequest) (response *DescribeDBClustersWithBackupsResponse, err error) {
	response = CreateDescribeDBClustersWithBackupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBClustersWithBackupsWithChan invokes the polardb.DescribeDBClustersWithBackups API asynchronously
func (client *Client) DescribeDBClustersWithBackupsWithChan(request *DescribeDBClustersWithBackupsRequest) (<-chan *DescribeDBClustersWithBackupsResponse, <-chan error) {
	responseChan := make(chan *DescribeDBClustersWithBackupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBClustersWithBackups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBClustersWithBackupsWithCallback invokes the polardb.DescribeDBClustersWithBackups API asynchronously
func (client *Client) DescribeDBClustersWithBackupsWithCallback(request *DescribeDBClustersWithBackupsRequest, callback func(response *DescribeDBClustersWithBackupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBClustersWithBackupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBClustersWithBackups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBClustersWithBackupsRequest is the request struct for api DescribeDBClustersWithBackups
type DescribeDBClustersWithBackupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBClusterDescription string           `position:"Query" name:"DBClusterDescription"`
	IsDeleted            requests.Integer `position:"Query" name:"IsDeleted"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBType               string           `position:"Query" name:"DBType"`
	DBVersion            string           `position:"Query" name:"DBVersion"`
	DBClusterIds         string           `position:"Query" name:"DBClusterIds"`
}

// DescribeDBClustersWithBackupsResponse is the response struct for api DescribeDBClustersWithBackups
type DescribeDBClustersWithBackupsResponse struct {
	*responses.BaseResponse
	RequestId        string                               `json:"RequestId" xml:"RequestId"`
	PageNumber       int                                  `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int                                  `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int                                  `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Items            ItemsInDescribeDBClustersWithBackups `json:"Items" xml:"Items"`
}

// CreateDescribeDBClustersWithBackupsRequest creates a request to invoke DescribeDBClustersWithBackups API
func CreateDescribeDBClustersWithBackupsRequest() (request *DescribeDBClustersWithBackupsRequest) {
	request = &DescribeDBClustersWithBackupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBClustersWithBackups", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBClustersWithBackupsResponse creates a response to parse from DescribeDBClustersWithBackups response
func CreateDescribeDBClustersWithBackupsResponse() (response *DescribeDBClustersWithBackupsResponse) {
	response = &DescribeDBClustersWithBackupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
