package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateColdDataVolume invokes the polardbx.AllocateColdDataVolume API synchronously
func (client *Client) AllocateColdDataVolume(request *AllocateColdDataVolumeRequest) (response *AllocateColdDataVolumeResponse, err error) {
	response = CreateAllocateColdDataVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateColdDataVolumeWithChan invokes the polardbx.AllocateColdDataVolume API asynchronously
func (client *Client) AllocateColdDataVolumeWithChan(request *AllocateColdDataVolumeRequest) (<-chan *AllocateColdDataVolumeResponse, <-chan error) {
	responseChan := make(chan *AllocateColdDataVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateColdDataVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateColdDataVolumeWithCallback invokes the polardbx.AllocateColdDataVolume API asynchronously
func (client *Client) AllocateColdDataVolumeWithCallback(request *AllocateColdDataVolumeRequest, callback func(response *AllocateColdDataVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateColdDataVolumeResponse
		var err error
		defer close(result)
		response, err = client.AllocateColdDataVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateColdDataVolumeRequest is the request struct for api AllocateColdDataVolume
type AllocateColdDataVolumeRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
}

// AllocateColdDataVolumeResponse is the response struct for api AllocateColdDataVolume
type AllocateColdDataVolumeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateColdDataVolumeRequest creates a request to invoke AllocateColdDataVolume API
func CreateAllocateColdDataVolumeRequest() (request *AllocateColdDataVolumeRequest) {
	request = &AllocateColdDataVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "AllocateColdDataVolume", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocateColdDataVolumeResponse creates a response to parse from AllocateColdDataVolume response
func CreateAllocateColdDataVolumeResponse() (response *AllocateColdDataVolumeResponse) {
	response = &AllocateColdDataVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
