package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddUserToVpcEndpointService invokes the privatelink.AddUserToVpcEndpointService API synchronously
func (client *Client) AddUserToVpcEndpointService(request *AddUserToVpcEndpointServiceRequest) (response *AddUserToVpcEndpointServiceResponse, err error) {
	response = CreateAddUserToVpcEndpointServiceResponse()
	err = client.DoAction(request, response)
	return
}

// AddUserToVpcEndpointServiceWithChan invokes the privatelink.AddUserToVpcEndpointService API asynchronously
func (client *Client) AddUserToVpcEndpointServiceWithChan(request *AddUserToVpcEndpointServiceRequest) (<-chan *AddUserToVpcEndpointServiceResponse, <-chan error) {
	responseChan := make(chan *AddUserToVpcEndpointServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddUserToVpcEndpointService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddUserToVpcEndpointServiceWithCallback invokes the privatelink.AddUserToVpcEndpointService API asynchronously
func (client *Client) AddUserToVpcEndpointServiceWithCallback(request *AddUserToVpcEndpointServiceRequest, callback func(response *AddUserToVpcEndpointServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddUserToVpcEndpointServiceResponse
		var err error
		defer close(result)
		response, err = client.AddUserToVpcEndpointService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddUserToVpcEndpointServiceRequest is the request struct for api AddUserToVpcEndpointService
type AddUserToVpcEndpointServiceRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	UserARN     string           `position:"Query" name:"UserARN"`
	UserId      requests.Integer `position:"Query" name:"UserId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ServiceId   string           `position:"Query" name:"ServiceId"`
}

// AddUserToVpcEndpointServiceResponse is the response struct for api AddUserToVpcEndpointService
type AddUserToVpcEndpointServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddUserToVpcEndpointServiceRequest creates a request to invoke AddUserToVpcEndpointService API
func CreateAddUserToVpcEndpointServiceRequest() (request *AddUserToVpcEndpointServiceRequest) {
	request = &AddUserToVpcEndpointServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "AddUserToVpcEndpointService", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddUserToVpcEndpointServiceResponse creates a response to parse from AddUserToVpcEndpointService response
func CreateAddUserToVpcEndpointServiceResponse() (response *AddUserToVpcEndpointServiceResponse) {
	response = &AddUserToVpcEndpointServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
