package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRuleV4Str invokes the qualitycheck.GetRuleV4Str API synchronously
func (client *Client) GetRuleV4Str(request *GetRuleV4StrRequest) (response *GetRuleV4StrResponse, err error) {
	response = CreateGetRuleV4StrResponse()
	err = client.DoAction(request, response)
	return
}

// GetRuleV4StrWithChan invokes the qualitycheck.GetRuleV4Str API asynchronously
func (client *Client) GetRuleV4StrWithChan(request *GetRuleV4StrRequest) (<-chan *GetRuleV4StrResponse, <-chan error) {
	responseChan := make(chan *GetRuleV4StrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRuleV4Str(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRuleV4StrWithCallback invokes the qualitycheck.GetRuleV4Str API asynchronously
func (client *Client) GetRuleV4StrWithCallback(request *GetRuleV4StrRequest, callback func(response *GetRuleV4StrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRuleV4StrResponse
		var err error
		defer close(result)
		response, err = client.GetRuleV4Str(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRuleV4StrRequest is the request struct for api GetRuleV4Str
type GetRuleV4StrRequest struct {
	*requests.RpcRequest
	IsSchemeData requests.Integer `position:"Body" name:"IsSchemeData"`
	RuleId       requests.Integer `position:"Body" name:"RuleId"`
}

// GetRuleV4StrResponse is the response struct for api GetRuleV4Str
type GetRuleV4StrResponse struct {
	*responses.BaseResponse
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateGetRuleV4StrRequest creates a request to invoke GetRuleV4Str API
func CreateGetRuleV4StrRequest() (request *GetRuleV4StrRequest) {
	request = &GetRuleV4StrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetRuleV4Str", "", "")
	request.Method = requests.POST
	return
}

// CreateGetRuleV4StrResponse creates a response to parse from GetRuleV4Str response
func CreateGetRuleV4StrResponse() (response *GetRuleV4StrResponse) {
	response = &GetRuleV4StrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
