package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMailTaskStatus invokes the quickbi_public.GetMailTaskStatus API synchronously
func (client *Client) GetMailTaskStatus(request *GetMailTaskStatusRequest) (response *GetMailTaskStatusResponse, err error) {
	response = CreateGetMailTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetMailTaskStatusWithChan invokes the quickbi_public.GetMailTaskStatus API asynchronously
func (client *Client) GetMailTaskStatusWithChan(request *GetMailTaskStatusRequest) (<-chan *GetMailTaskStatusResponse, <-chan error) {
	responseChan := make(chan *GetMailTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMailTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMailTaskStatusWithCallback invokes the quickbi_public.GetMailTaskStatus API asynchronously
func (client *Client) GetMailTaskStatusWithCallback(request *GetMailTaskStatusRequest, callback func(response *GetMailTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMailTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.GetMailTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMailTaskStatusRequest is the request struct for api GetMailTaskStatus
type GetMailTaskStatusRequest struct {
	*requests.RpcRequest
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	MailId      string           `position:"Query" name:"MailId"`
	TaskId      requests.Integer `position:"Query" name:"TaskId"`
	SignType    string           `position:"Query" name:"SignType"`
}

// GetMailTaskStatusResponse is the response struct for api GetMailTaskStatus
type GetMailTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    []DATA `json:"Result" xml:"Result"`
}

// CreateGetMailTaskStatusRequest creates a request to invoke GetMailTaskStatus API
func CreateGetMailTaskStatusRequest() (request *GetMailTaskStatusRequest) {
	request = &GetMailTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "GetMailTaskStatus", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMailTaskStatusResponse creates a response to parse from GetMailTaskStatus response
func CreateGetMailTaskStatusResponse() (response *GetMailTaskStatusResponse) {
	response = &GetMailTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
