package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTemplateQuotaItem invokes the quotas.ModifyTemplateQuotaItem API synchronously
func (client *Client) ModifyTemplateQuotaItem(request *ModifyTemplateQuotaItemRequest) (response *ModifyTemplateQuotaItemResponse, err error) {
	response = CreateModifyTemplateQuotaItemResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTemplateQuotaItemWithChan invokes the quotas.ModifyTemplateQuotaItem API asynchronously
func (client *Client) ModifyTemplateQuotaItemWithChan(request *ModifyTemplateQuotaItemRequest) (<-chan *ModifyTemplateQuotaItemResponse, <-chan error) {
	responseChan := make(chan *ModifyTemplateQuotaItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTemplateQuotaItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTemplateQuotaItemWithCallback invokes the quotas.ModifyTemplateQuotaItem API asynchronously
func (client *Client) ModifyTemplateQuotaItemWithCallback(request *ModifyTemplateQuotaItemRequest, callback func(response *ModifyTemplateQuotaItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTemplateQuotaItemResponse
		var err error
		defer close(result)
		response, err = client.ModifyTemplateQuotaItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTemplateQuotaItemRequest is the request struct for api ModifyTemplateQuotaItem
type ModifyTemplateQuotaItemRequest struct {
	*requests.RpcRequest
	ProductCode     string                               `position:"Body" name:"ProductCode"`
	QuotaActionCode string                               `position:"Body" name:"QuotaActionCode"`
	DesireValue     requests.Float                       `position:"Body" name:"DesireValue"`
	EffectiveTime   string                               `position:"Body" name:"EffectiveTime"`
	Id              string                               `position:"Body" name:"Id"`
	QuotaCategory   string                               `position:"Query" name:"QuotaCategory"`
	OriginalContext string                               `position:"Body" name:"OriginalContext"`
	ExpireTime      string                               `position:"Body" name:"ExpireTime"`
	EnvLanguage     string                               `position:"Body" name:"EnvLanguage"`
	NoticeType      requests.Integer                     `position:"Body" name:"NoticeType"`
	Dimensions      *[]ModifyTemplateQuotaItemDimensions `position:"Body" name:"Dimensions"  type:"Repeated"`
}

// ModifyTemplateQuotaItemDimensions is a repeated param struct in ModifyTemplateQuotaItemRequest
type ModifyTemplateQuotaItemDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ModifyTemplateQuotaItemResponse is the response struct for api ModifyTemplateQuotaItem
type ModifyTemplateQuotaItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateModifyTemplateQuotaItemRequest creates a request to invoke ModifyTemplateQuotaItem API
func CreateModifyTemplateQuotaItemRequest() (request *ModifyTemplateQuotaItemRequest) {
	request = &ModifyTemplateQuotaItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ModifyTemplateQuotaItem", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTemplateQuotaItemResponse creates a response to parse from ModifyTemplateQuotaItem response
func CreateModifyTemplateQuotaItemResponse() (response *ModifyTemplateQuotaItemResponse) {
	response = &ModifyTemplateQuotaItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
