package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartTairKVCacheCustomInstance invokes the r_kvstore.StartTairKVCacheCustomInstance API synchronously
func (client *Client) StartTairKVCacheCustomInstance(request *StartTairKVCacheCustomInstanceRequest) (response *StartTairKVCacheCustomInstanceResponse, err error) {
	response = CreateStartTairKVCacheCustomInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StartTairKVCacheCustomInstanceWithChan invokes the r_kvstore.StartTairKVCacheCustomInstance API asynchronously
func (client *Client) StartTairKVCacheCustomInstanceWithChan(request *StartTairKVCacheCustomInstanceRequest) (<-chan *StartTairKVCacheCustomInstanceResponse, <-chan error) {
	responseChan := make(chan *StartTairKVCacheCustomInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartTairKVCacheCustomInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartTairKVCacheCustomInstanceWithCallback invokes the r_kvstore.StartTairKVCacheCustomInstance API asynchronously
func (client *Client) StartTairKVCacheCustomInstanceWithCallback(request *StartTairKVCacheCustomInstanceRequest, callback func(response *StartTairKVCacheCustomInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartTairKVCacheCustomInstanceResponse
		var err error
		defer close(result)
		response, err = client.StartTairKVCacheCustomInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartTairKVCacheCustomInstanceRequest is the request struct for api StartTairKVCacheCustomInstance
type StartTairKVCacheCustomInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// StartTairKVCacheCustomInstanceResponse is the response struct for api StartTairKVCacheCustomInstance
type StartTairKVCacheCustomInstanceResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	TaskId     string `json:"TaskId" xml:"TaskId"`
}

// CreateStartTairKVCacheCustomInstanceRequest creates a request to invoke StartTairKVCacheCustomInstance API
func CreateStartTairKVCacheCustomInstanceRequest() (request *StartTairKVCacheCustomInstanceRequest) {
	request = &StartTairKVCacheCustomInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "StartTairKVCacheCustomInstance", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStartTairKVCacheCustomInstanceResponse creates a response to parse from StartTairKVCacheCustomInstance response
func CreateStartTairKVCacheCustomInstanceResponse() (response *StartTairKVCacheCustomInstanceResponse) {
	response = &StartTairKVCacheCustomInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
