package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustinsResourceInfo invokes the rds.DescribeCustinsResourceInfo API synchronously
func (client *Client) DescribeCustinsResourceInfo(request *DescribeCustinsResourceInfoRequest) (response *DescribeCustinsResourceInfoResponse, err error) {
	response = CreateDescribeCustinsResourceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustinsResourceInfoWithChan invokes the rds.DescribeCustinsResourceInfo API asynchronously
func (client *Client) DescribeCustinsResourceInfoWithChan(request *DescribeCustinsResourceInfoRequest) (<-chan *DescribeCustinsResourceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeCustinsResourceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustinsResourceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustinsResourceInfoWithCallback invokes the rds.DescribeCustinsResourceInfo API asynchronously
func (client *Client) DescribeCustinsResourceInfoWithCallback(request *DescribeCustinsResourceInfoRequest, callback func(response *DescribeCustinsResourceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustinsResourceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustinsResourceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustinsResourceInfoRequest is the request struct for api DescribeCustinsResourceInfo
type DescribeCustinsResourceInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceIds        string           `position:"Query" name:"DBInstanceIds"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCustinsResourceInfoResponse is the response struct for api DescribeCustinsResourceInfo
type DescribeCustinsResourceInfoResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeCustinsResourceInfoRequest creates a request to invoke DescribeCustinsResourceInfo API
func CreateDescribeCustinsResourceInfoRequest() (request *DescribeCustinsResourceInfoRequest) {
	request = &DescribeCustinsResourceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeCustinsResourceInfo", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustinsResourceInfoResponse creates a response to parse from DescribeCustinsResourceInfo response
func CreateDescribeCustinsResourceInfoResponse() (response *DescribeCustinsResourceInfoResponse) {
	response = &DescribeCustinsResourceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
