package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceConnectivity invokes the rds.DescribeDBInstanceConnectivity API synchronously
func (client *Client) DescribeDBInstanceConnectivity(request *DescribeDBInstanceConnectivityRequest) (response *DescribeDBInstanceConnectivityResponse, err error) {
	response = CreateDescribeDBInstanceConnectivityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceConnectivityWithChan invokes the rds.DescribeDBInstanceConnectivity API asynchronously
func (client *Client) DescribeDBInstanceConnectivityWithChan(request *DescribeDBInstanceConnectivityRequest) (<-chan *DescribeDBInstanceConnectivityResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceConnectivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceConnectivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceConnectivityWithCallback invokes the rds.DescribeDBInstanceConnectivity API asynchronously
func (client *Client) DescribeDBInstanceConnectivityWithCallback(request *DescribeDBInstanceConnectivityRequest, callback func(response *DescribeDBInstanceConnectivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceConnectivityResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceConnectivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceConnectivityRequest is the request struct for api DescribeDBInstanceConnectivity
type DescribeDBInstanceConnectivityRequest struct {
	*requests.RpcRequest
	DbInstanceName       string           `position:"Query" name:"DbInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	SourceIpAddress      string           `position:"Query" name:"SourceIpAddress"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBInstanceConnectivityResponse is the response struct for api DescribeDBInstanceConnectivity
type DescribeDBInstanceConnectivityResponse struct {
	*responses.BaseResponse
	RequestId             string `json:"RequestId" xml:"RequestId"`
	DbInstanceName        string `json:"DbInstanceName" xml:"DbInstanceName"`
	ConnCheckResult       string `json:"ConnCheckResult" xml:"ConnCheckResult"`
	ConnCheckErrorCode    string `json:"ConnCheckErrorCode" xml:"ConnCheckErrorCode"`
	ConnCheckErrorMessage string `json:"ConnCheckErrorMessage" xml:"ConnCheckErrorMessage"`
}

// CreateDescribeDBInstanceConnectivityRequest creates a request to invoke DescribeDBInstanceConnectivity API
func CreateDescribeDBInstanceConnectivityRequest() (request *DescribeDBInstanceConnectivityRequest) {
	request = &DescribeDBInstanceConnectivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBInstanceConnectivity", "rds", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDBInstanceConnectivityResponse creates a response to parse from DescribeDBInstanceConnectivity response
func CreateDescribeDBInstanceConnectivityResponse() (response *DescribeDBInstanceConnectivityResponse) {
	response = &DescribeDBInstanceConnectivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
