package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceEndpoint invokes the rds.ModifyDBInstanceEndpoint API synchronously
func (client *Client) ModifyDBInstanceEndpoint(request *ModifyDBInstanceEndpointRequest) (response *ModifyDBInstanceEndpointResponse, err error) {
	response = CreateModifyDBInstanceEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceEndpointWithChan invokes the rds.ModifyDBInstanceEndpoint API asynchronously
func (client *Client) ModifyDBInstanceEndpointWithChan(request *ModifyDBInstanceEndpointRequest) (<-chan *ModifyDBInstanceEndpointResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceEndpointWithCallback invokes the rds.ModifyDBInstanceEndpoint API asynchronously
func (client *Client) ModifyDBInstanceEndpointWithCallback(request *ModifyDBInstanceEndpointRequest, callback func(response *ModifyDBInstanceEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceEndpointResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceEndpointRequest is the request struct for api ModifyDBInstanceEndpoint
type ModifyDBInstanceEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId               requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
	DBInstanceId                  string           `position:"Query" name:"DBInstanceId"`
	DBInstanceEndpointDescription string           `position:"Query" name:"DBInstanceEndpointDescription"`
	NodeItems                     string           `position:"Query" name:"NodeItems"`
	DBInstanceEndpointId          string           `position:"Query" name:"DBInstanceEndpointId"`
}

// ModifyDBInstanceEndpointResponse is the response struct for api ModifyDBInstanceEndpoint
type ModifyDBInstanceEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyDBInstanceEndpointRequest creates a request to invoke ModifyDBInstanceEndpoint API
func CreateModifyDBInstanceEndpointRequest() (request *ModifyDBInstanceEndpointRequest) {
	request = &ModifyDBInstanceEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBInstanceEndpoint", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceEndpointResponse creates a response to parse from ModifyDBInstanceEndpoint response
func CreateModifyDBInstanceEndpointResponse() (response *ModifyDBInstanceEndpointResponse) {
	response = &ModifyDBInstanceEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
