package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPGHbaConfig invokes the rds.ModifyPGHbaConfig API synchronously
func (client *Client) ModifyPGHbaConfig(request *ModifyPGHbaConfigRequest) (response *ModifyPGHbaConfigResponse, err error) {
	response = CreateModifyPGHbaConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPGHbaConfigWithChan invokes the rds.ModifyPGHbaConfig API asynchronously
func (client *Client) ModifyPGHbaConfigWithChan(request *ModifyPGHbaConfigRequest) (<-chan *ModifyPGHbaConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyPGHbaConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPGHbaConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPGHbaConfigWithCallback invokes the rds.ModifyPGHbaConfig API asynchronously
func (client *Client) ModifyPGHbaConfigWithCallback(request *ModifyPGHbaConfigRequest, callback func(response *ModifyPGHbaConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPGHbaConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyPGHbaConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPGHbaConfigRequest is the request struct for api ModifyPGHbaConfig
type ModifyPGHbaConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer            `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                      `position:"Query" name:"ClientToken"`
	OpsType              string                      `position:"Query" name:"OpsType"`
	DBInstanceId         string                      `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string                      `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                      `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer            `position:"Query" name:"OwnerId"`
	HbaItem              *[]ModifyPGHbaConfigHbaItem `position:"Query" name:"HbaItem"  type:"Repeated"`
}

// ModifyPGHbaConfigHbaItem is a repeated param struct in ModifyPGHbaConfigRequest
type ModifyPGHbaConfigHbaItem struct {
	Database   string `name:"Database"`
	Address    string `name:"Address"`
	Method     string `name:"Method"`
	Type       string `name:"Type"`
	User       string `name:"User"`
	Mask       string `name:"Mask"`
	PriorityId string `name:"PriorityId"`
	Option     string `name:"Option"`
}

// ModifyPGHbaConfigResponse is the response struct for api ModifyPGHbaConfig
type ModifyPGHbaConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPGHbaConfigRequest creates a request to invoke ModifyPGHbaConfig API
func CreateModifyPGHbaConfigRequest() (request *ModifyPGHbaConfigRequest) {
	request = &ModifyPGHbaConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyPGHbaConfig", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyPGHbaConfigResponse creates a response to parse from ModifyPGHbaConfig response
func CreateModifyPGHbaConfigResponse() (response *ModifyPGHbaConfigResponse) {
	response = &ModifyPGHbaConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
