package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteSQLQuery invokes the resourcecenter.ExecuteSQLQuery API synchronously
func (client *Client) ExecuteSQLQuery(request *ExecuteSQLQueryRequest) (response *ExecuteSQLQueryResponse, err error) {
	response = CreateExecuteSQLQueryResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteSQLQueryWithChan invokes the resourcecenter.ExecuteSQLQuery API asynchronously
func (client *Client) ExecuteSQLQueryWithChan(request *ExecuteSQLQueryRequest) (<-chan *ExecuteSQLQueryResponse, <-chan error) {
	responseChan := make(chan *ExecuteSQLQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteSQLQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteSQLQueryWithCallback invokes the resourcecenter.ExecuteSQLQuery API asynchronously
func (client *Client) ExecuteSQLQueryWithCallback(request *ExecuteSQLQueryRequest, callback func(response *ExecuteSQLQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteSQLQueryResponse
		var err error
		defer close(result)
		response, err = client.ExecuteSQLQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteSQLQueryRequest is the request struct for api ExecuteSQLQuery
type ExecuteSQLQueryRequest struct {
	*requests.RpcRequest
	Expression string           `position:"Query" name:"Expression"`
	NextToken  string           `position:"Query" name:"NextToken"`
	Scope      string           `position:"Query" name:"Scope"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
}

// ExecuteSQLQueryResponse is the response struct for api ExecuteSQLQuery
type ExecuteSQLQueryResponse struct {
	*responses.BaseResponse
	MaxResults int      `json:"MaxResults" xml:"MaxResults"`
	NextToken  string   `json:"NextToken" xml:"NextToken"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Rows       []string `json:"Rows" xml:"Rows"`
	Columns    []Column `json:"Columns" xml:"Columns"`
}

// CreateExecuteSQLQueryRequest creates a request to invoke ExecuteSQLQuery API
func CreateExecuteSQLQueryRequest() (request *ExecuteSQLQueryRequest) {
	request = &ExecuteSQLQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "ExecuteSQLQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateExecuteSQLQueryResponse creates a response to parse from ExecuteSQLQuery response
func CreateExecuteSQLQueryResponse() (response *ExecuteSQLQueryResponse) {
	response = &ExecuteSQLQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
