package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDelegatedAdministrators invokes the resourcemanager.ListDelegatedAdministrators API synchronously
func (client *Client) ListDelegatedAdministrators(request *ListDelegatedAdministratorsRequest) (response *ListDelegatedAdministratorsResponse, err error) {
	response = CreateListDelegatedAdministratorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDelegatedAdministratorsWithChan invokes the resourcemanager.ListDelegatedAdministrators API asynchronously
func (client *Client) ListDelegatedAdministratorsWithChan(request *ListDelegatedAdministratorsRequest) (<-chan *ListDelegatedAdministratorsResponse, <-chan error) {
	responseChan := make(chan *ListDelegatedAdministratorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDelegatedAdministrators(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDelegatedAdministratorsWithCallback invokes the resourcemanager.ListDelegatedAdministrators API asynchronously
func (client *Client) ListDelegatedAdministratorsWithCallback(request *ListDelegatedAdministratorsRequest, callback func(response *ListDelegatedAdministratorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDelegatedAdministratorsResponse
		var err error
		defer close(result)
		response, err = client.ListDelegatedAdministrators(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDelegatedAdministratorsRequest is the request struct for api ListDelegatedAdministrators
type ListDelegatedAdministratorsRequest struct {
	*requests.RpcRequest
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	ServicePrincipal string           `position:"Query" name:"ServicePrincipal"`
}

// ListDelegatedAdministratorsResponse is the response struct for api ListDelegatedAdministrators
type ListDelegatedAdministratorsResponse struct {
	*responses.BaseResponse
	RequestId  string                                `json:"RequestId" xml:"RequestId"`
	TotalCount int64                                 `json:"TotalCount" xml:"TotalCount"`
	PageSize   int64                                 `json:"PageSize" xml:"PageSize"`
	PageNumber int64                                 `json:"PageNumber" xml:"PageNumber"`
	Accounts   AccountsInListDelegatedAdministrators `json:"Accounts" xml:"Accounts"`
}

// CreateListDelegatedAdministratorsRequest creates a request to invoke ListDelegatedAdministrators API
func CreateListDelegatedAdministratorsRequest() (request *ListDelegatedAdministratorsRequest) {
	request = &ListDelegatedAdministratorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListDelegatedAdministrators", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDelegatedAdministratorsResponse creates a response to parse from ListDelegatedAdministrators response
func CreateListDelegatedAdministratorsResponse() (response *ListDelegatedAdministratorsResponse) {
	response = &ListDelegatedAdministratorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
