package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetailDigitalTemplate invokes the retailadvqa_public.DetailDigitalTemplate API synchronously
func (client *Client) DetailDigitalTemplate(request *DetailDigitalTemplateRequest) (response *DetailDigitalTemplateResponse, err error) {
	response = CreateDetailDigitalTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DetailDigitalTemplateWithChan invokes the retailadvqa_public.DetailDigitalTemplate API asynchronously
func (client *Client) DetailDigitalTemplateWithChan(request *DetailDigitalTemplateRequest) (<-chan *DetailDigitalTemplateResponse, <-chan error) {
	responseChan := make(chan *DetailDigitalTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetailDigitalTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetailDigitalTemplateWithCallback invokes the retailadvqa_public.DetailDigitalTemplate API asynchronously
func (client *Client) DetailDigitalTemplateWithCallback(request *DetailDigitalTemplateRequest, callback func(response *DetailDigitalTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetailDigitalTemplateResponse
		var err error
		defer close(result)
		response, err = client.DetailDigitalTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetailDigitalTemplateRequest is the request struct for api DetailDigitalTemplate
type DetailDigitalTemplateRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	TenantId    string `position:"Query" name:"TenantId"`
	Id          string `position:"Query" name:"Id"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// DetailDigitalTemplateResponse is the response struct for api DetailDigitalTemplate
type DetailDigitalTemplateResponse struct {
	*responses.BaseResponse
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDetailDigitalTemplateRequest creates a request to invoke DetailDigitalTemplate API
func CreateDetailDigitalTemplateRequest() (request *DetailDigitalTemplateRequest) {
	request = &DetailDigitalTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "DetailDigitalTemplate", "", "")
	request.Method = requests.GET
	return
}

// CreateDetailDigitalTemplateResponse creates a response to parse from DetailDigitalTemplate response
func CreateDetailDigitalTemplateResponse() (response *DetailDigitalTemplateResponse) {
	response = &DetailDigitalTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
