package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAccount invokes the retailadvqa_public.ListAccount API synchronously
func (client *Client) ListAccount(request *ListAccountRequest) (response *ListAccountResponse, err error) {
	response = CreateListAccountResponse()
	err = client.DoAction(request, response)
	return
}

// ListAccountWithChan invokes the retailadvqa_public.ListAccount API asynchronously
func (client *Client) ListAccountWithChan(request *ListAccountRequest) (<-chan *ListAccountResponse, <-chan error) {
	responseChan := make(chan *ListAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAccountWithCallback invokes the retailadvqa_public.ListAccount API asynchronously
func (client *Client) ListAccountWithCallback(request *ListAccountRequest, callback func(response *ListAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAccountResponse
		var err error
		defer close(result)
		response, err = client.ListAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAccountRequest is the request struct for api ListAccount
type ListAccountRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	TenantId    string `position:"Query" name:"TenantId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// ListAccountResponse is the response struct for api ListAccount
type ListAccountResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	ErrorDesc string     `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string     `json:"TraceId" xml:"TraceId"`
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListAccountRequest creates a request to invoke ListAccount API
func CreateListAccountRequest() (request *ListAccountRequest) {
	request = &ListAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ListAccount", "", "")
	request.Method = requests.POST
	return
}

// CreateListAccountResponse creates a response to parse from ListAccount response
func CreateListAccountResponse() (response *ListAccountResponse) {
	response = &ListAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
