package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetArmsTopNMetric invokes the sae.GetArmsTopNMetric API synchronously
func (client *Client) GetArmsTopNMetric(request *GetArmsTopNMetricRequest) (response *GetArmsTopNMetricResponse, err error) {
	response = CreateGetArmsTopNMetricResponse()
	err = client.DoAction(request, response)
	return
}

// GetArmsTopNMetricWithChan invokes the sae.GetArmsTopNMetric API asynchronously
func (client *Client) GetArmsTopNMetricWithChan(request *GetArmsTopNMetricRequest) (<-chan *GetArmsTopNMetricResponse, <-chan error) {
	responseChan := make(chan *GetArmsTopNMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetArmsTopNMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetArmsTopNMetricWithCallback invokes the sae.GetArmsTopNMetric API asynchronously
func (client *Client) GetArmsTopNMetricWithCallback(request *GetArmsTopNMetricRequest, callback func(response *GetArmsTopNMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetArmsTopNMetricResponse
		var err error
		defer close(result)
		response, err = client.GetArmsTopNMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetArmsTopNMetricRequest is the request struct for api GetArmsTopNMetric
type GetArmsTopNMetricRequest struct {
	*requests.RoaRequest
	AppSource   string           `position:"Query" name:"AppSource"`
	CpuStrategy string           `position:"Query" name:"CpuStrategy"`
	Limit       requests.Integer `position:"Query" name:"Limit"`
	OrderBy     string           `position:"Query" name:"OrderBy"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
}

// GetArmsTopNMetricResponse is the response struct for api GetArmsTopNMetric
type GetArmsTopNMetricResponse struct {
	*responses.BaseResponse
	Message   string          `json:"Message" xml:"Message"`
	RequestId string          `json:"RequestId" xml:"RequestId"`
	Code      string          `json:"Code" xml:"Code"`
	Success   bool            `json:"Success" xml:"Success"`
	Data      []ArmsMetricDto `json:"Data" xml:"Data"`
}

// CreateGetArmsTopNMetricRequest creates a request to invoke GetArmsTopNMetric API
func CreateGetArmsTopNMetricRequest() (request *GetArmsTopNMetricRequest) {
	request = &GetArmsTopNMetricRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "GetArmsTopNMetric", "/pop/v1/sam/getArmsTopNMetric", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetArmsTopNMetricResponse creates a response to parse from GetArmsTopNMetric response
func CreateGetArmsTopNMetricResponse() (response *GetArmsTopNMetricResponse) {
	response = &GetArmsTopNMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
