package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryBlockEvent invokes the safe.QueryBlockEvent API synchronously
func (client *Client) QueryBlockEvent(request *QueryBlockEventRequest) (response *QueryBlockEventResponse, err error) {
	response = CreateQueryBlockEventResponse()
	err = client.DoAction(request, response)
	return
}

// QueryBlockEventWithChan invokes the safe.QueryBlockEvent API asynchronously
func (client *Client) QueryBlockEventWithChan(request *QueryBlockEventRequest) (<-chan *QueryBlockEventResponse, <-chan error) {
	responseChan := make(chan *QueryBlockEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryBlockEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryBlockEventWithCallback invokes the safe.QueryBlockEvent API asynchronously
func (client *Client) QueryBlockEventWithCallback(request *QueryBlockEventRequest, callback func(response *QueryBlockEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryBlockEventResponse
		var err error
		defer close(result)
		response, err = client.QueryBlockEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryBlockEventRequest is the request struct for api QueryBlockEvent
type QueryBlockEventRequest struct {
	*requests.RpcRequest
	AuthKey      string                       `position:"Body" name:"AuthKey"`
	RegionReqs   *[]QueryBlockEventRegionReqs `position:"Body" name:"RegionReqs"  type:"Repeated"`
	BlockHarm    string                       `position:"Body" name:"BlockHarm"`
	AuthSign     string                       `position:"Body" name:"AuthSign"`
	EndTime      requests.Integer             `position:"Body" name:"EndTime"`
	StartTime    requests.Integer             `position:"Body" name:"StartTime"`
	DeptNo       string                       `position:"Body" name:"DeptNo"`
	ReqTimestamp requests.Integer             `position:"Body" name:"ReqTimestamp"`
	NeedRule     requests.Boolean             `position:"Body" name:"NeedRule"`
	Scope        *[]string                    `position:"Query" name:"Scope"  type:"Repeated"`
	Limit        requests.Integer             `position:"Body" name:"Limit"`
	ProductCodes *[]string                    `position:"Body" name:"ProductCodes"  type:"Repeated"`
	Page         requests.Integer             `position:"Body" name:"Page"`
	Category     string                       `position:"Body" name:"Category"`
	BgSystemName string                       `position:"Body" name:"BgSystemName"`
}

// QueryBlockEventRegionReqs is a repeated param struct in QueryBlockEventRequest
type QueryBlockEventRegionReqs struct {
	ProductCode string    `name:"ProductCode"`
	Regions     *[]string `name:"Regions" type:"Repeated"`
}

// QueryBlockEventResponse is the response struct for api QueryBlockEvent
type QueryBlockEventResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryBlockEventRequest creates a request to invoke QueryBlockEvent API
func CreateQueryBlockEventRequest() (request *QueryBlockEventRequest) {
	request = &QueryBlockEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryBlockEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryBlockEventResponse creates a response to parse from QueryBlockEvent response
func CreateQueryBlockEventResponse() (response *QueryBlockEventResponse) {
	response = &QueryBlockEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
