package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCheckInfo invokes the safe.QueryCheckInfo API synchronously
func (client *Client) QueryCheckInfo(request *QueryCheckInfoRequest) (response *QueryCheckInfoResponse, err error) {
	response = CreateQueryCheckInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCheckInfoWithChan invokes the safe.QueryCheckInfo API asynchronously
func (client *Client) QueryCheckInfoWithChan(request *QueryCheckInfoRequest) (<-chan *QueryCheckInfoResponse, <-chan error) {
	responseChan := make(chan *QueryCheckInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCheckInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCheckInfoWithCallback invokes the safe.QueryCheckInfo API asynchronously
func (client *Client) QueryCheckInfoWithCallback(request *QueryCheckInfoRequest, callback func(response *QueryCheckInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCheckInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryCheckInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCheckInfoRequest is the request struct for api QueryCheckInfo
type QueryCheckInfoRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Body" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Body" name:"ReqTimestamp"`
	AuthSign      string           `position:"Body" name:"AuthSign"`
	SourceOrderId string           `position:"Body" name:"SourceOrderId"`
}

// QueryCheckInfoResponse is the response struct for api QueryCheckInfo
type QueryCheckInfoResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCheckInfoRequest creates a request to invoke QueryCheckInfo API
func CreateQueryCheckInfoRequest() (request *QueryCheckInfoRequest) {
	request = &QueryCheckInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryCheckInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryCheckInfoResponse creates a response to parse from QueryCheckInfo response
func CreateQueryCheckInfoResponse() (response *QueryCheckInfoResponse) {
	response = &QueryCheckInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
