package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeEnd invokes the safe.SafeChangeEnd API synchronously
func (client *Client) SafeChangeEnd(request *SafeChangeEndRequest) (response *SafeChangeEndResponse, err error) {
	response = CreateSafeChangeEndResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeEndWithChan invokes the safe.SafeChangeEnd API asynchronously
func (client *Client) SafeChangeEndWithChan(request *SafeChangeEndRequest) (<-chan *SafeChangeEndResponse, <-chan error) {
	responseChan := make(chan *SafeChangeEndResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeEnd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeEndWithCallback invokes the safe.SafeChangeEnd API asynchronously
func (client *Client) SafeChangeEndWithCallback(request *SafeChangeEndRequest, callback func(response *SafeChangeEndResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeEndResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeEnd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeEndRequest is the request struct for api SafeChangeEnd
type SafeChangeEndRequest struct {
	*requests.RpcRequest
	TotalBatchNo  requests.Integer `position:"Body" name:"TotalBatchNo"`
	AuthKey       string           `position:"Body" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Body" name:"ReqTimestamp"`
	ExecutorEmpId string           `position:"Body" name:"ExecutorEmpId"`
	ChangeEndTime requests.Integer `position:"Body" name:"ChangeEndTime"`
	CurBatchNo    requests.Integer `position:"Body" name:"CurBatchNo"`
	SourceOrderId string           `position:"Body" name:"SourceOrderId"`
	AuthSign      string           `position:"Body" name:"AuthSign"`
	ChangeResult  string           `position:"Body" name:"ChangeResult"`
}

// SafeChangeEndResponse is the response struct for api SafeChangeEnd
type SafeChangeEndResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeChangeEndRequest creates a request to invoke SafeChangeEnd API
func CreateSafeChangeEndRequest() (request *SafeChangeEndRequest) {
	request = &SafeChangeEndRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeEnd", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeEndResponse creates a response to parse from SafeChangeEnd response
func CreateSafeChangeEndResponse() (response *SafeChangeEndResponse) {
	response = &SafeChangeEndResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
