package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFileDetectUploadUrl invokes the sas.CreateFileDetectUploadUrl API synchronously
func (client *Client) CreateFileDetectUploadUrl(request *CreateFileDetectUploadUrlRequest) (response *CreateFileDetectUploadUrlResponse, err error) {
	response = CreateCreateFileDetectUploadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFileDetectUploadUrlWithChan invokes the sas.CreateFileDetectUploadUrl API asynchronously
func (client *Client) CreateFileDetectUploadUrlWithChan(request *CreateFileDetectUploadUrlRequest) (<-chan *CreateFileDetectUploadUrlResponse, <-chan error) {
	responseChan := make(chan *CreateFileDetectUploadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFileDetectUploadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFileDetectUploadUrlWithCallback invokes the sas.CreateFileDetectUploadUrl API asynchronously
func (client *Client) CreateFileDetectUploadUrlWithCallback(request *CreateFileDetectUploadUrlRequest, callback func(response *CreateFileDetectUploadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFileDetectUploadUrlResponse
		var err error
		defer close(result)
		response, err = client.CreateFileDetectUploadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFileDetectUploadUrlRequest is the request struct for api CreateFileDetectUploadUrl
type CreateFileDetectUploadUrlRequest struct {
	*requests.RpcRequest
	HashKeyList        *[]string                                      `position:"Query" name:"HashKeyList"  type:"Repeated"`
	Type               requests.Integer                               `position:"Query" name:"Type"`
	HashKeyContextList *[]CreateFileDetectUploadUrlHashKeyContextList `position:"Query" name:"HashKeyContextList"  type:"Repeated"`
}

// CreateFileDetectUploadUrlHashKeyContextList is a repeated param struct in CreateFileDetectUploadUrlRequest
type CreateFileDetectUploadUrlHashKeyContextList struct {
	HashKey  string `name:"HashKey"`
	FileSize string `name:"FileSize"`
}

// CreateFileDetectUploadUrlResponse is the response struct for api CreateFileDetectUploadUrl
type CreateFileDetectUploadUrlResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	UploadUrlList []UploadUrList `json:"UploadUrlList" xml:"UploadUrlList"`
}

// CreateCreateFileDetectUploadUrlRequest creates a request to invoke CreateFileDetectUploadUrl API
func CreateCreateFileDetectUploadUrlRequest() (request *CreateFileDetectUploadUrlRequest) {
	request = &CreateFileDetectUploadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CreateFileDetectUploadUrl", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFileDetectUploadUrlResponse creates a response to parse from CreateFileDetectUploadUrl response
func CreateCreateFileDetectUploadUrlResponse() (response *CreateFileDetectUploadUrlResponse) {
	response = &CreateFileDetectUploadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
