package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcHoneyPotList invokes the sas.DescribeVpcHoneyPotList API synchronously
func (client *Client) DescribeVpcHoneyPotList(request *DescribeVpcHoneyPotListRequest) (response *DescribeVpcHoneyPotListResponse, err error) {
	response = CreateDescribeVpcHoneyPotListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcHoneyPotListWithChan invokes the sas.DescribeVpcHoneyPotList API asynchronously
func (client *Client) DescribeVpcHoneyPotListWithChan(request *DescribeVpcHoneyPotListRequest) (<-chan *DescribeVpcHoneyPotListResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcHoneyPotListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcHoneyPotList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcHoneyPotListWithCallback invokes the sas.DescribeVpcHoneyPotList API asynchronously
func (client *Client) DescribeVpcHoneyPotListWithCallback(request *DescribeVpcHoneyPotListRequest, callback func(response *DescribeVpcHoneyPotListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcHoneyPotListResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcHoneyPotList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcHoneyPotListRequest is the request struct for api DescribeVpcHoneyPotList
type DescribeVpcHoneyPotListRequest struct {
	*requests.RpcRequest
	VpcName           string           `position:"Query" name:"VpcName"`
	SourceIp          string           `position:"Query" name:"SourceIp"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	HoneyPotExistence requests.Boolean `position:"Query" name:"HoneyPotExistence"`
	VpcRegionId       string           `position:"Query" name:"VpcRegionId"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	VpcId             string           `position:"Query" name:"VpcId"`
}

// DescribeVpcHoneyPotListResponse is the response struct for api DescribeVpcHoneyPotList
type DescribeVpcHoneyPotListResponse struct {
	*responses.BaseResponse
	RequestId          string           `json:"RequestId" xml:"RequestId"`
	PageInfo           PageInfo         `json:"PageInfo" xml:"PageInfo"`
	VpcHoneyPotDTOList []VpcHoneyPotDTO `json:"VpcHoneyPotDTOList" xml:"VpcHoneyPotDTOList"`
}

// CreateDescribeVpcHoneyPotListRequest creates a request to invoke DescribeVpcHoneyPotList API
func CreateDescribeVpcHoneyPotListRequest() (request *DescribeVpcHoneyPotListRequest) {
	request = &DescribeVpcHoneyPotListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeVpcHoneyPotList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcHoneyPotListResponse creates a response to parse from DescribeVpcHoneyPotList response
func CreateDescribeVpcHoneyPotListResponse() (response *DescribeVpcHoneyPotListResponse) {
	response = &DescribeVpcHoneyPotListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
