package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshAssets invokes the sas.RefreshAssets API synchronously
func (client *Client) RefreshAssets(request *RefreshAssetsRequest) (response *RefreshAssetsResponse, err error) {
	response = CreateRefreshAssetsResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshAssetsWithChan invokes the sas.RefreshAssets API asynchronously
func (client *Client) RefreshAssetsWithChan(request *RefreshAssetsRequest) (<-chan *RefreshAssetsResponse, <-chan error) {
	responseChan := make(chan *RefreshAssetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshAssets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshAssetsWithCallback invokes the sas.RefreshAssets API asynchronously
func (client *Client) RefreshAssetsWithCallback(request *RefreshAssetsRequest, callback func(response *RefreshAssetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshAssetsResponse
		var err error
		defer close(result)
		response, err = client.RefreshAssets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshAssetsRequest is the request struct for api RefreshAssets
type RefreshAssetsRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	AssetType string `position:"Query" name:"AssetType"`
}

// RefreshAssetsResponse is the response struct for api RefreshAssets
type RefreshAssetsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefreshAssetsRequest creates a request to invoke RefreshAssets API
func CreateRefreshAssetsRequest() (request *RefreshAssetsRequest) {
	request = &RefreshAssetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "RefreshAssets", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshAssetsResponse creates a response to parse from RefreshAssets response
func CreateRefreshAssetsResponse() (response *RefreshAssetsResponse) {
	response = &RefreshAssetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
