package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScdnCcInfo invokes the scdn.DescribeScdnCcInfo API synchronously
func (client *Client) DescribeScdnCcInfo(request *DescribeScdnCcInfoRequest) (response *DescribeScdnCcInfoResponse, err error) {
	response = CreateDescribeScdnCcInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScdnCcInfoWithChan invokes the scdn.DescribeScdnCcInfo API asynchronously
func (client *Client) DescribeScdnCcInfoWithChan(request *DescribeScdnCcInfoRequest) (<-chan *DescribeScdnCcInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeScdnCcInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScdnCcInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScdnCcInfoWithCallback invokes the scdn.DescribeScdnCcInfo API asynchronously
func (client *Client) DescribeScdnCcInfoWithCallback(request *DescribeScdnCcInfoRequest, callback func(response *DescribeScdnCcInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScdnCcInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeScdnCcInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScdnCcInfoRequest is the request struct for api DescribeScdnCcInfo
type DescribeScdnCcInfoRequest struct {
	*requests.RpcRequest
}

// DescribeScdnCcInfoResponse is the response struct for api DescribeScdnCcInfo
type DescribeScdnCcInfoResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeScdnCcInfoRequest creates a request to invoke DescribeScdnCcInfo API
func CreateDescribeScdnCcInfoRequest() (request *DescribeScdnCcInfoRequest) {
	request = &DescribeScdnCcInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "DescribeScdnCcInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeScdnCcInfoResponse creates a response to parse from DescribeScdnCcInfo response
func CreateDescribeScdnCcInfoResponse() (response *DescribeScdnCcInfoResponse) {
	response = &DescribeScdnCcInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
